/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.personalorganizer.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.persistence.jdbc.sql.JdbcSqlQuery;
import org.silverpeas.core.personalorganizer.model.Attendee;
import org.silverpeas.core.util.MapUtil;

public class AttendeeDAO {
    private static final String JOURNALCOLUMNNAMES = "userId, journalId, participationStatus";
    private static final String TODOCOLUMNNAMES = "userId, todoId, participationStatus";
    private static final String JOURNALTABLENAME = "CalendarJournalAttendee";
    private static final String TODOTABLENAME = "CalendarToDoAttendee";
    private static final String JOURNALIDNAME = "journalId";
    private static final String TODOIDNAME = "todoId";

    private AttendeeDAO() {
        throw new IllegalAccessError("Utility class");
    }

    private static Attendee getAttendeeFromResultSet(ResultSet rs) throws SQLException {
        String userId = rs.getString(1);
        String participation = rs.getString(3);
        return new Attendee(userId, participation);
    }

    static Collection<Attendee> getJournalAttendees(String journalId) throws SQLException {
        return AttendeeDAO.getJournalAttendees(Collections.singletonList(journalId)).getOrDefault(journalId, Collections.emptyList());
    }

    static Map<String, List<Attendee>> getJournalAttendees(List<String> journalIds) throws SQLException {
        return AttendeeDAO.getAttendees(journalIds, JOURNALCOLUMNNAMES, JOURNALTABLENAME, JOURNALIDNAME);
    }

    static List<Attendee> getToDoAttendees(String todoId) throws SQLException {
        return AttendeeDAO.getToDoAttendees(Collections.singletonList(todoId)).getOrDefault(todoId, Collections.emptyList());
    }

    static Map<String, List<Attendee>> getToDoAttendees(Collection<String> todoIds) throws SQLException {
        return AttendeeDAO.getAttendees(todoIds, TODOCOLUMNNAMES, TODOTABLENAME, TODOIDNAME);
    }

    private static Map<String, List<Attendee>> getAttendees(Collection<String> ids, String columns, String table, String idLabel) throws SQLException {
        return JdbcSqlQuery.executeBySplittingOn(ids, (idBatch, result) -> JdbcSqlQuery.select((String)columns).from(new String[]{table}).where(idLabel, new Object[0]).in((Collection)idBatch.stream().map(Integer::parseInt).collect(Collectors.toList())).execute(r -> {
            String id = r.getString(2);
            Attendee attendee = AttendeeDAO.getAttendeeFromResultSet((ResultSet)r);
            MapUtil.putAddList((Map)result, (Object)id, (Object)attendee);
            return null;
        }));
    }

    static void addJournalAttendee(Connection con, String journalId, Attendee attendee) throws SQLException {
        AttendeeDAO.addAttendee(con, journalId, attendee, JOURNALCOLUMNNAMES, JOURNALTABLENAME);
    }

    static void addToDoAttendee(Connection con, String todoId, Attendee attendee) throws SQLException {
        AttendeeDAO.addAttendee(con, todoId, attendee, TODOCOLUMNNAMES, TODOTABLENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAttendee(Connection con, String id, Attendee attendee, String columns, String table) throws SQLException {
        String insertStatement = "insert into " + table + " (" + columns + ")  values (?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement(insertStatement);
            prepStmt.setString(1, attendee.getUserId());
            prepStmt.setInt(2, Integer.parseInt(id));
            prepStmt.setString(3, attendee.getParticipationStatus().getString());
            prepStmt.executeUpdate();
        }
        finally {
            DBUtil.close((Statement)prepStmt);
        }
    }

    static void removeJournalAttendee(Connection con, String journalId, Attendee attendee) throws SQLException {
        AttendeeDAO.removeAttendee(con, journalId, attendee, JOURNALTABLENAME, JOURNALIDNAME);
    }

    static void removeToDoAttendee(Connection con, String todoId, Attendee attendee) throws SQLException {
        AttendeeDAO.removeAttendee(con, todoId, attendee, TODOTABLENAME, TODOIDNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAttendee(Connection con, String id, Attendee attendee, String table, String idLabel) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            String statement = "delete from " + table + " where " + idLabel + " = ? and userId = ?";
            prepStmt = con.prepareStatement(statement);
            prepStmt.setInt(1, Integer.parseInt(id));
            prepStmt.setString(2, attendee.getUserId());
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtil.close(prepStmt);
            throw throwable;
        }
        DBUtil.close((Statement)prepStmt);
    }

    public static void removeJournal(String journalId) throws SQLException {
        AttendeeDAO.removeAttendees(journalId, JOURNALTABLENAME, JOURNALIDNAME);
    }

    static void removeToDo(String todoId) throws SQLException {
        AttendeeDAO.removeAttendees(todoId, TODOTABLENAME, TODOIDNAME);
    }

    private static void removeAttendees(String id, String table, String idLabel) throws SQLException {
        JdbcSqlQuery.deleteFrom((String)table).where(idLabel + " = ?", new Object[]{Integer.parseInt(id)}).execute();
    }
}

