/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.model;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.components.kmelia.model.FileDetail;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;

public class FileFolder
implements Serializable {
    private static final long serialVersionUID = 5071147110169726697L;
    private ArrayList children;
    private ArrayList files;
    private ArrayList folders;
    private String name;
    private String path;

    public FileFolder(String path) {
        this.path = path;
        this.files = new ArrayList(0);
        this.folders = new ArrayList(0);
        this.children = new ArrayList(0);
        try {
            File f = new File(path);
            if (f.exists()) {
                this.name = f.getName();
                String[] childrenName = f.list();
                for (int i = 0; childrenName != null && i < childrenName.length; ++i) {
                    File fChild = new File(path + File.separator + childrenName[i]);
                    this.children.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                    if (fChild.isDirectory()) {
                        this.folders.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                        continue;
                    }
                    this.files.add(new FileDetail(fChild.getName(), fChild.getPath(), fChild.length(), fChild.isDirectory()));
                }
            }
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    public Collection getFiles() {
        return this.files;
    }

    public Collection getFolders() {
        return this.folders;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public List getChildren() {
        return this.children;
    }
}

