/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.classifieds.notification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.silverpeas.components.classifieds.model.ClassifiedDetail;
import org.silverpeas.components.classifieds.notification.AbstractClassifiedUserNotification;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.notification.user.client.constant.NotifAction;

public class ClassifiedSupervisorUserNotification
extends AbstractClassifiedUserNotification {
    public ClassifiedSupervisorUserNotification(ClassifiedDetail resource) {
        super(resource);
    }

    protected Collection<String> getUserIdsToNotify() {
        List<String> roles = Collections.singletonList("admin");
        OrganizationController organizationController = OrganizationControllerProvider.getOrganisationController();
        return new ArrayList<String>(Arrays.asList(organizationController.getUsersIdsByRoleNames(this.getComponentInstanceId(), roles)));
    }

    protected String getTemplateFileName() {
        return "tovalidate";
    }

    protected String getBundleSubjectKey() {
        return "classifieds.supervisorNotifSubject";
    }

    protected NotifAction getAction() {
        return NotifAction.PENDING_VALIDATION;
    }

    protected boolean isSendImmediately() {
        return true;
    }

    protected void perform(ClassifiedDetail resource) {
        super.perform((Object)resource);
        this.getNotificationMetaData().displayReceiversInFooter();
    }
}

