/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;

public class CloseableIterator<T>
implements Iterator<T>,
Closeable {
    private final Iterator<T> iterator;
    private final Closeable closeable;

    public static <T> CloseableIterator<T> wrap(Iterator<T> iterator, Closeable closeable) {
        return new CloseableIterator<T>(iterator, closeable);
    }

    public static <T> CloseableIterator<T> wrap(Iterator<T> iterator) {
        return new CloseableIterator<T>(iterator, null);
    }

    public CloseableIterator(Iterator<T> iterable, Closeable closeable) {
        this.iterator = iterable;
        this.closeable = closeable;
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public T next() {
        return this.iterator.next();
    }
}

