/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.HistogramStats;
import org.apache.jackrabbit.oak.stats.MeterStats;
import org.apache.jackrabbit.oak.stats.TimerStats;

final class CompositeStats
implements CounterStats,
MeterStats,
TimerStats,
HistogramStats {
    private final AtomicLong delegate;
    private final Counter counter;
    private final Timer timer;
    private final Meter meter;
    private final Histogram histogram;
    private final Counting counting;

    public CompositeStats(AtomicLong delegate, Counter counter) {
        this(delegate, counter, null, null, null, (Counting)counter);
    }

    public CompositeStats(AtomicLong delegate, Timer timer) {
        this(delegate, null, timer, null, null, (Counting)timer);
    }

    public CompositeStats(AtomicLong delegate, Meter meter) {
        this(delegate, null, null, meter, null, (Counting)meter);
    }

    public CompositeStats(AtomicLong delegate, Histogram histogram) {
        this(delegate, null, null, null, histogram, (Counting)histogram);
    }

    private CompositeStats(AtomicLong delegate, Counter counter, Timer timer, Meter meter, Histogram histogram, Counting counting) {
        this.delegate = delegate;
        this.counter = counter;
        this.timer = timer;
        this.meter = meter;
        this.histogram = histogram;
        this.counting = counting;
    }

    public long getCount() {
        return this.counting.getCount();
    }

    public void inc() {
        this.delegate.getAndIncrement();
        this.counter.inc();
    }

    public void dec() {
        this.delegate.getAndDecrement();
        this.counter.dec();
    }

    public void inc(long n) {
        this.delegate.getAndAdd(n);
        this.counter.inc(n);
    }

    public void dec(long n) {
        this.delegate.getAndAdd(-n);
        this.counter.dec(n);
    }

    public void mark() {
        this.delegate.getAndIncrement();
        this.meter.mark();
    }

    public void mark(long n) {
        this.delegate.getAndAdd(n);
        this.meter.mark(n);
    }

    public void update(long duration, TimeUnit unit) {
        this.delegate.getAndAdd(unit.toMillis(duration));
        this.timer.update(duration, unit);
    }

    public void update(long value) {
        this.delegate.getAndAdd(value);
        this.histogram.update(value);
    }

    public TimerStats.Context time() {
        return new StatsContext(this.timer.time(), this.delegate);
    }

    boolean isMeter() {
        return this.meter != null;
    }

    boolean isTimer() {
        return this.timer != null;
    }

    boolean isCounter() {
        return this.counter != null;
    }

    boolean isHistogram() {
        return this.histogram != null;
    }

    Counter getCounter() {
        return this.counter;
    }

    Timer getTimer() {
        return this.timer;
    }

    Meter getMeter() {
        return this.meter;
    }

    Histogram getHistogram() {
        return this.histogram;
    }

    private static final class StatsContext
    implements TimerStats.Context {
        private final Timer.Context context;
        private final AtomicLong delegate;

        private StatsContext(Timer.Context context, AtomicLong delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public long stop() {
            long nanos = this.context.stop();
            this.delegate.getAndAdd(TimeUnit.NANOSECONDS.toMillis(nanos));
            return nanos;
        }

        public void close() {
            this.stop();
        }
    }
}

