/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import org.apache.jackrabbit.oak.segment.file.AbstractGarbageCollectionStrategy;
import org.apache.jackrabbit.oak.segment.file.CleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.CompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.DefaultCleanupStrategy;
import org.apache.jackrabbit.oak.segment.file.EstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.FallbackCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.FullCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.FullSizeDeltaEstimationStrategy;
import org.apache.jackrabbit.oak.segment.file.TailCompactionStrategy;
import org.apache.jackrabbit.oak.segment.file.TailSizeDeltaEstimationStrategy;

class DefaultGarbageCollectionStrategy
extends AbstractGarbageCollectionStrategy {
    DefaultGarbageCollectionStrategy() {
    }

    @Override
    EstimationStrategy getFullEstimationStrategy() {
        return new FullSizeDeltaEstimationStrategy();
    }

    @Override
    EstimationStrategy getTailEstimationStrategy() {
        return new TailSizeDeltaEstimationStrategy();
    }

    @Override
    CompactionStrategy getFullCompactionStrategy() {
        return new FullCompactionStrategy();
    }

    @Override
    CompactionStrategy getTailCompactionStrategy() {
        return new FallbackCompactionStrategy(new TailCompactionStrategy(), new FullCompactionStrategy());
    }

    @Override
    CleanupStrategy getCleanupStrategy() {
        return new DefaultCleanupStrategy();
    }
}

