/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user;

import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.jetbrains.annotations.NotNull;

public enum AuthorizableType {
    USER(1),
    GROUP(2),
    AUTHORIZABLE(3);

    private final int userType;

    private AuthorizableType(int jcrUserType) {
        this.userType = jcrUserType;
    }

    @NotNull
    public static AuthorizableType getType(int jcrUserType) {
        switch (jcrUserType) {
            case 3: {
                return AUTHORIZABLE;
            }
            case 2: {
                return GROUP;
            }
            case 1: {
                return USER;
            }
        }
        throw new IllegalArgumentException("Invalid authorizable type " + jcrUserType);
    }

    public boolean isType(Authorizable authorizable) {
        if (authorizable == null) {
            return false;
        }
        switch (this.userType) {
            case 2: {
                return authorizable.isGroup();
            }
            case 1: {
                return !authorizable.isGroup();
            }
        }
        return true;
    }

    public Class<? extends Authorizable> getAuthorizableClass() {
        switch (this.userType) {
            case 2: {
                return Group.class;
            }
            case 1: {
                return User.class;
            }
        }
        return Authorizable.class;
    }
}

