/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.silvercrawler.model;

import java.io.Serializable;
import org.silverpeas.components.silvercrawler.util.FileServerUtils;
import org.silverpeas.core.util.file.FileRepositoryManager;

public class FileDetail
implements Serializable {
    private static final long serialVersionUID = 4697608390797941792L;
    private String name;
    private String path;
    private String fullPath;
    private long size;
    private boolean isDirectory;
    private boolean isIndexed;

    public FileDetail(String name, String path, String fullPath, long size, boolean isDirectory) {
        this.name = name;
        this.path = path;
        this.fullPath = fullPath;
        this.size = size;
        this.isDirectory = isDirectory;
    }

    public FileDetail(String name, String path, String fullPath, long size, boolean isDirectory, boolean isIndexed) {
        this.name = name;
        this.path = path;
        this.fullPath = fullPath;
        this.size = size;
        this.isDirectory = isDirectory;
        this.isIndexed = isIndexed;
    }

    public String getFileSize() {
        return FileRepositoryManager.formatFileSize((long)this.size);
    }

    public String getFileIcon() {
        String fileType = FileRepositoryManager.getFileExtension((String)this.name);
        return FileRepositoryManager.getFileIcon((String)fileType);
    }

    public String getFileURL(String componentId) {
        return FileServerUtils.getSilverCrawlerUrl(this.name, this.path, componentId);
    }

    public boolean isIsDirectory() {
        return this.isDirectory;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isIsIndexed() {
        return this.isIndexed;
    }

    public String getDirectURL() {
        if (this.fullPath.startsWith("/")) {
            return "file://" + this.fullPath;
        }
        return "file:///" + this.fullPath;
    }
}

