/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file.proc;

import org.apache.jackrabbit.oak.segment.file.proc.BulkSegmentNode;
import org.apache.jackrabbit.oak.segment.file.proc.DataSegmentNode;
import org.apache.jackrabbit.oak.segment.file.proc.MissingSegmentNode;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class SegmentNode {
    private SegmentNode() {
    }

    static NodeState newSegmentNode(Proc.Backend backend, String segmentId) {
        return backend.getSegment(segmentId).map(segment -> SegmentNode.newSegmentNode(backend, segmentId, segment)).orElseGet(() -> SegmentNode.newMissingSegment(segmentId));
    }

    private static NodeState newSegmentNode(Proc.Backend backend, String segmentId, Proc.Backend.Segment segment) {
        if (segment.isDataSegment()) {
            return new DataSegmentNode(backend, segmentId, segment);
        }
        return new BulkSegmentNode(backend, segmentId, segment);
    }

    private static NodeState newMissingSegment(String segmentId) {
        return new MissingSegmentNode(segmentId);
    }
}

