/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.model.MediaPK;
import org.silverpeas.components.gallery.service.GalleryService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.contentcontainer.content.AbstractSilverpeasContentManager;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.util.ServiceProvider;

@Service
public class GalleryContentManager
extends AbstractSilverpeasContentManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT_ICON_FILE_NAME = "gallerySmall.gif";

    protected GalleryContentManager() {
    }

    protected String getContentIconFileName(String componentInstanceId) {
        return CONTENT_ICON_FILE_NAME;
    }

    protected Optional<Contribution> getContribution(String resourceId, String componentInstanceId) {
        return Optional.ofNullable(this.getGalleryService().getMedia(new MediaPK(resourceId, componentInstanceId), MediaCriteria.VISIBILITY.FORCE_GET_ALL));
    }

    protected List<Contribution> getAccessibleContributions(List<ResourceReference> resourceReferences, String currentUserId) {
        return resourceReferences.stream().collect(Collectors.groupingBy(ResourceReference::getComponentInstanceId, Collectors.mapping(ResourceReference::getLocalId, Collectors.toList()))).entrySet().stream().flatMap(e -> this.getGalleryService().getMedia((List)e.getValue(), (String)e.getKey(), MediaCriteria.VISIBILITY.FORCE_GET_ALL).stream()).collect(Collectors.toList());
    }

    protected <T extends Contribution> SilverContentVisibility computeSilverContentVisibility(T contribution) {
        return null;
    }

    private GalleryService getGalleryService() {
        return (GalleryService)ServiceProvider.getService(GalleryService.class, (Annotation[])new Annotation[0]);
    }
}

