/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnsElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderElement;
import org.odftoolkit.odfdom.dom.element.style.StyleSectionPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.field.AbstractVariableContainer;
import org.odftoolkit.simple.common.field.VariableContainer;
import org.odftoolkit.simple.common.field.VariableField;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.odftoolkit.simple.text.Section;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Header
extends Component
implements TableContainer,
VariableContainer {
    private StyleHeaderElement headerEle;
    private TableContainerImpl tableContainerImpl;
    private VariableContainerImpl variableContainerImpl;

    public Header(StyleHeaderElement element) {
        this.headerEle = element;
    }

    public StyleHeaderElement getOdfElement() {
        return this.headerEle;
    }

    public boolean isVisible() {
        boolean isVisible = this.headerEle.getStyleDisplayAttribute();
        return isVisible;
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.headerEle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "display");
        } else {
            this.headerEle.setStyleDisplayAttribute(Boolean.valueOf(false));
        }
        NodeList nodeList = this.headerEle.getElementsByTagName(TextPElement.ELEMENT_NAME.getQName());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            TextPElement textEle = (TextPElement)nodeList.item(i);
            String stylename = textEle.getStyleName();
            OdfFileDom dom = (OdfFileDom)this.headerEle.getOwnerDocument();
            OdfOfficeAutomaticStyles styles = null;
            if (dom instanceof OdfContentDom) {
                styles = ((OdfContentDom)dom).getAutomaticStyles();
            } else if (dom instanceof OdfStylesDom) {
                styles = ((OdfStylesDom)dom).getAutomaticStyles();
            }
            OdfStyle newStyle = styles.newStyle(OdfStyleFamily.Paragraph);
            OdfStyle style = styles.getStyle(stylename, OdfStyleFamily.Paragraph);
            if (style != null) {
                String styleName = newStyle.getStyleNameAttribute();
                styles.removeChild((Node)newStyle);
                newStyle = (OdfStyle)style.cloneNode(true);
                newStyle.setStyleNameAttribute(styleName);
                styles.appendChild((Node)newStyle);
            }
            if (isVisible) {
                if (newStyle.hasProperty(StyleTextPropertiesElement.Display)) {
                    newStyle.removeProperty(StyleTextPropertiesElement.Display);
                }
            } else {
                newStyle.setProperty(StyleTextPropertiesElement.Display, "none");
            }
            textEle.setStyleName(newStyle.getStyleNameAttribute());
        }
    }

    @Override
    public Table addTable() {
        Table table = this.getTableContainerImpl().addTable();
        this.updateTableToNone(table);
        return table;
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        Table table = this.getTableContainerImpl().addTable(numRows, numCols);
        this.updateTableToNone(table);
        return table;
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    @Override
    public OdfElement getVariableContainerElement() {
        return this.getVariableContainerImpl().getVariableContainerElement();
    }

    @Override
    public VariableField declareVariable(String name, VariableField.VariableType type) {
        return this.getVariableContainerImpl().declareVariable(name, type);
    }

    @Override
    public VariableField getVariableFieldByName(String name) {
        return this.getVariableContainerImpl().getVariableFieldByName(name);
    }

    private TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    private VariableContainer getVariableContainerImpl() {
        if (this.variableContainerImpl == null) {
            this.variableContainerImpl = new VariableContainerImpl();
        }
        return this.variableContainerImpl;
    }

    private void updateTableToNone(Table table) {
        OdfFileDom dom = (OdfFileDom)this.getTableContainerElement().getOwnerDocument();
        TableTableElement tableEle = table.getOdfElement();
        String stylename = tableEle.getStyleName();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfStyle tableStyle = styles.getStyle(stylename, OdfStyleFamily.Table);
        tableStyle.setProperty(StyleTablePropertiesElement.Shadow, "none");
        NodeList cells = tableEle.getElementsByTagNameNS(OdfDocumentNamespace.TABLE.getUri(), "table-cell");
        if (cells != null && cells.getLength() > 0) {
            OdfStyle cellStyleWithoutBorder = styles.newStyle(OdfStyleFamily.TableCell);
            cellStyleWithoutBorder.setProperty(StyleTableCellPropertiesElement.Border, "none");
            cellStyleWithoutBorder.removeProperty(StyleTableCellPropertiesElement.Padding);
            String cellStyleName = cellStyleWithoutBorder.getStyleNameAttribute();
            for (int i = 0; i < cells.getLength(); ++i) {
                TableTableCellElement cell = (TableTableCellElement)cells.item(i);
                cell.setStyleName(cellStyleName);
            }
        }
    }

    public Section appendSection(String name) {
        TextSectionElement newSectionEle = null;
        try {
            Document doc = (Document)((OdfFileDom)this.headerEle.getOwnerDocument()).getDocument();
            OdfContentDom contentDocument = doc.getContentDom();
            OdfOfficeAutomaticStyles styles = contentDocument.getAutomaticStyles();
            OdfStyle style = styles.newStyle(OdfStyleFamily.Section);
            StyleSectionPropertiesElement sProperties = style.newStyleSectionPropertiesElement();
            sProperties.setTextDontBalanceTextColumnsAttribute(Boolean.valueOf(false));
            sProperties.setStyleEditableAttribute(Boolean.valueOf(false));
            StyleColumnsElement columnEle = sProperties.newStyleColumnsElement(1);
            columnEle.setFoColumnGapAttribute("0in");
            newSectionEle = this.headerEle.newTextSectionElement("true", name);
            newSectionEle.setStyleName(style.getStyleNameAttribute());
            return Section.getInstance(newSectionEle);
        }
        catch (Exception e) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(name + "Section appends failed.", e);
        }
    }

    private class VariableContainerImpl
    extends AbstractVariableContainer {
        private VariableContainerImpl() {
        }

        @Override
        public OdfElement getVariableContainerElement() {
            try {
                return Header.this.headerEle;
            }
            catch (Exception e) {
                Logger.getLogger(Header.class.getName()).log(Level.SEVERE, null, e);
                return null;
            }
        }
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        @Override
        public OdfElement getTableContainerElement() {
            return Header.this.headerEle;
        }
    }
}

