/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache;

import java.nio.ByteBuffer;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.LocalDiffCache;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.NamePathRev;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Path;
import org.apache.jackrabbit.oak.plugins.document.PathRev;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.DataTypeUtil;
import org.apache.jackrabbit.oak.plugins.document.util.RevisionsKey;
import org.apache.jackrabbit.oak.plugins.document.util.StringValue;
import org.h2.mvstore.WriteBuffer;
import org.h2.mvstore.type.StringDataType;

public enum CacheType {
    NODE{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            PathRev pr = (PathRev)key;
            DataTypeUtil.pathRevToBuffer(pr, buffer);
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            return (K)DataTypeUtil.pathRevFromBuffer(buffer);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((PathRev)a).compareTo((PathRev)b);
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            DataTypeUtil.stateToBuffer((DocumentNodeState)((Object)value), buffer);
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            return (V)((Object)DataTypeUtil.stateFromBuffer(store, buffer));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            Path path = ((PathRev)key).getPath();
            if (!store.getNodeCachePredicate().apply((Object)path)) {
                return false;
            }
            return !store.getNodeStateCache().isCached(path);
        }
    }
    ,
    CHILDREN{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            DataTypeUtil.namePathRevToBuffer((NamePathRev)key, buffer);
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            return (K)DataTypeUtil.namePathRevFromBuffer(buffer);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((NamePathRev)a).compareTo((NamePathRev)b);
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            String s = ((DocumentNodeState.Children)value).asString();
            StringDataType.INSTANCE.write(buffer, s);
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            return (V)DocumentNodeState.Children.fromString(CacheType.readString(buffer));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            Path path = ((NamePathRev)key).getPath();
            if (!store.getNodeCachePredicate().apply((Object)path)) {
                return false;
            }
            return !store.getNodeStateCache().isCached(path);
        }
    }
    ,
    DIFF{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            MemoryDiffCache.Key k = (MemoryDiffCache.Key)key;
            DataTypeUtil.pathToBuffer(k.getPath(), buffer);
            DataTypeUtil.revisionVectorToBuffer(k.getFromRevision(), buffer);
            DataTypeUtil.revisionVectorToBuffer(k.getToRevision(), buffer);
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            Path p = DataTypeUtil.pathFromBuffer(buffer);
            RevisionVector from = DataTypeUtil.revisionVectorFromBuffer(buffer);
            RevisionVector to = DataTypeUtil.revisionVectorFromBuffer(buffer);
            return (K)new MemoryDiffCache.Key(p, from, to);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((MemoryDiffCache.Key)a).compareTo((MemoryDiffCache.Key)b);
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            String s = ((StringValue)value).asString();
            StringDataType.INSTANCE.write(buffer, s);
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            return (V)StringValue.fromString(CacheType.readString(buffer));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    }
    ,
    DOCUMENT{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return false;
        }
    }
    ,
    PREV_DOCUMENT{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            String s = ((StringValue)key).asString();
            StringDataType.INSTANCE.write(buffer, s);
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            return (K)StringValue.fromString(CacheType.readString(buffer));
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((StringValue)a).asString().compareTo(((StringValue)b).asString());
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            String s = ((NodeDocument)value).asString();
            StringDataType.INSTANCE.write(buffer, s);
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            return (V)NodeDocument.fromString(docStore, CacheType.readString(buffer));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    }
    ,
    LOCAL_DIFF{

        @Override
        public <K> void writeKey(WriteBuffer buffer, K key) {
            RevisionsKey revisionsKey = (RevisionsKey)key;
            DataTypeUtil.revisionVectorToBuffer(revisionsKey.getRev1(), buffer);
            DataTypeUtil.revisionVectorToBuffer(revisionsKey.getRev2(), buffer);
        }

        @Override
        public <K> K readKey(ByteBuffer buffer) {
            RevisionVector rv1 = DataTypeUtil.revisionVectorFromBuffer(buffer);
            RevisionVector rv2 = DataTypeUtil.revisionVectorFromBuffer(buffer);
            return (K)new RevisionsKey(rv1, rv2);
        }

        @Override
        public <K> int compareKeys(K a, K b) {
            return ((RevisionsKey)a).compareTo((RevisionsKey)b);
        }

        @Override
        public <V> void writeValue(WriteBuffer buffer, V value) {
            String s = ((LocalDiffCache.Diff)value).asString();
            StringDataType.INSTANCE.write(buffer, s);
        }

        @Override
        public <V> V readValue(DocumentNodeStore store, DocumentStore docStore, ByteBuffer buffer) {
            return (V)LocalDiffCache.Diff.fromString(CacheType.readString(buffer));
        }

        @Override
        public <K> boolean shouldCache(DocumentNodeStore store, K key) {
            return true;
        }
    };

    public static final CacheType[] VALUES;

    public String getMapName() {
        return this.name() + "-v1";
    }

    public abstract <K> void writeKey(WriteBuffer var1, K var2);

    public abstract <K> K readKey(ByteBuffer var1);

    public abstract <K> int compareKeys(K var1, K var2);

    public abstract <V> void writeValue(WriteBuffer var1, V var2);

    public abstract <V> V readValue(DocumentNodeStore var1, DocumentStore var2, ByteBuffer var3);

    public abstract <K> boolean shouldCache(DocumentNodeStore var1, K var2);

    private static String readString(ByteBuffer buffer) {
        return StringDataType.INSTANCE.read(buffer);
    }

    static {
        VALUES = CacheType.values();
    }
}

