/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.jetbrains.annotations.NotNull;

class Rollback {
    static final Rollback FAILED = new Rollback(Revision.newRevision(0), Collections.emptyList(), "", 1){

        @Override
        void perform(@NotNull DocumentStore store) throws DocumentStoreException {
            throw new DocumentStoreException("rollback failed");
        }
    };
    static final Rollback NONE = new Rollback(Revision.newRevision(0), Collections.emptyList(), "", 1){

        @Override
        void perform(@NotNull DocumentStore store) throws DocumentStoreException {
        }
    };
    private final Revision revision;
    private final List<UpdateOp> changed;
    private final String commitRootId;
    private final int batchSize;

    Rollback(@NotNull Revision revision, @NotNull List<UpdateOp> changed, @NotNull String commitRootId, int batchSize) {
        this.revision = revision;
        this.changed = (List)Preconditions.checkNotNull(changed);
        this.commitRootId = (String)Preconditions.checkNotNull((Object)commitRootId);
        this.batchSize = batchSize;
    }

    void perform(@NotNull DocumentStore store) throws DocumentStoreException {
        Preconditions.checkNotNull((Object)store);
        ArrayList<UpdateOp> reverseOps = new ArrayList<UpdateOp>();
        for (UpdateOp op : this.changed) {
            UpdateOp reverse = op.getReverseOperation();
            if (op.isNew()) {
                NodeDocument.setDeletedOnce(reverse);
            }
            reverse.setNew(false);
            reverseOps.add(reverse);
        }
        for (List ops : Lists.partition(reverseOps, (int)this.batchSize)) {
            store.createOrUpdate(Collection.NODES, ops);
        }
        this.removeCollisionMarker(store, this.commitRootId);
    }

    private void removeCollisionMarker(DocumentStore store, String id) {
        UpdateOp removeCollision = new UpdateOp(id, false);
        NodeDocument.removeCollision(removeCollision, this.revision);
        store.findAndUpdate(Collection.NODES, removeCollision);
    }
}

