/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.json.BlobDeserializer;
import org.apache.jackrabbit.oak.json.BlobSerializer;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.util.Base64;
import org.gradle.internal.classpath.Instrumented;

public class Base64BlobSerializer
extends BlobSerializer
implements BlobDeserializer {
    private static final int DEFAULT_LIMIT = Instrumented.getInteger((String)"oak.serializer.maxBlobSize", (int)0x100000, (String)"org.apache.jackrabbit.oak.json.Base64BlobSerializer");
    private final int maxSize;

    public Base64BlobSerializer() {
        this(DEFAULT_LIMIT);
    }

    public Base64BlobSerializer(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public String serialize(Blob blob) {
        String string;
        block8: {
            Preconditions.checkArgument((blob.length() < (long)this.maxSize ? 1 : 0) != 0, (String)"Cannot serialize Blob of size [%s] which is more than allowed maxSize of [%s]", (long)blob.length(), (int)this.maxSize);
            InputStream is = blob.getNewStream();
            try {
                StringWriter writer = new StringWriter();
                Base64.encode((InputStream)is, (Writer)writer);
                string = writer.toString();
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return string;
    }

    @Override
    public Blob deserialize(String value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringReader reader = new StringReader(value);
        try {
            Base64.decode((Reader)reader, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new ArrayBasedBlob(baos.toByteArray());
    }
}

