/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.silverpeas.core.web.SilverpeasWebResource;

public class WebResourceUri {
    private final String webResourcePath;
    private final HttpServletRequest request;
    private final UriInfo uriInfo;

    public WebResourceUri(String webResourcePath, HttpServletRequest request, UriInfo uriInfo) {
        this.webResourcePath = webResourcePath;
        this.request = request;
        this.uriInfo = uriInfo;
    }

    public WebResourceUri(String webResourcePath, HttpServletRequest request) {
        this(webResourcePath, request, null);
    }

    public HttpServletRequest getHttpRequest() {
        return this.request;
    }

    public URI getWebResourcePath() {
        return SilverpeasWebResource.getBasePathBuilder().path(this.webResourcePath).build(new Object[0]);
    }

    public UriBuilder getWebResourcePathBuilder() {
        return SilverpeasWebResource.getBasePathBuilder().path(this.webResourcePath);
    }

    public URI getAbsoluteWebResourcePath() {
        return SilverpeasWebResource.getBaseUriBuilder(this.request).path(this.webResourcePath).build(new Object[0]);
    }

    public UriBuilder getAbsoluteWebResourcePathBuilder() {
        return SilverpeasWebResource.getBaseUriBuilder(this.request).path(this.webResourcePath);
    }

    public URI getPath() {
        return this.getPathBuilder().build(new Object[0]);
    }

    public UriBuilder getPathBuilder() {
        return SilverpeasWebResource.getBasePathBuilder().path(this.request.getPathInfo());
    }

    public URI getRequestUri() {
        return this.getRequestUriBuilder().build(new Object[0]);
    }

    public UriBuilder getRequestUriBuilder() {
        UriBuilder uri = SilverpeasWebResource.getBaseUriBuilder(this.request).path(this.uriInfo.getPath());
        this.uriInfo.getQueryParameters().forEach((q, v) -> uri.queryParam(q, v.toArray(new Object[0])));
        return uri;
    }

    public URI getAbsolutePath() {
        return this.getAbsolutePathBuilder().build(new Object[0]);
    }

    public UriBuilder getAbsolutePathBuilder() {
        return SilverpeasWebResource.getBaseUriBuilder(this.request).path(this.request.getPathInfo());
    }

    public URI getBaseUri() {
        return this.getBaseUriBuilder().build(new Object[0]);
    }

    public UriBuilder getBaseUriBuilder() {
        return SilverpeasWebResource.getBaseUriBuilder(this.request);
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.uriInfo.getPathParameters();
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.uriInfo.getQueryParameters();
    }
}

