/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.util.Hashtable;
import java.util.Vector;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.simple.common.navigation.Selection;
import org.odftoolkit.simple.common.navigation.TextSelection;

public class SelectionManager {
    private Hashtable<OdfElement, Vector<Selection>> repository = new Hashtable();

    public void registerItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey(element)) {
            int i;
            Vector<Selection> selections = this.repository.get(element);
            for (i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() <= item.getIndex()) continue;
                selections.insertElementAt(item, i);
                break;
            }
            if (i == selections.size()) {
                selections.add(item);
            }
        } else {
            Vector<Selection> al = new Vector<Selection>();
            al.add(item);
            this.repository.put(element, al);
        }
    }

    public synchronized void refreshAfterCut(Selection cutItem) {
        OdfElement element = cutItem.getElement();
        if (this.repository.containsKey(element)) {
            Vector<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() <= cutItem.getIndex()) continue;
                selections.get(i).refreshAfterFrontalDelete(cutItem);
            }
        }
    }

    public synchronized void refreshAfterPasteAtFrontOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        if (this.repository.containsKey(element)) {
            Vector<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionItem.getIndex()) continue;
                selections.get(i).refreshAfterFrontalInsert(item);
            }
        }
    }

    public synchronized void refreshAfterPasteAtEndOf(Selection item, Selection positionItem) {
        OdfElement element = positionItem.getElement();
        int positionIndex = positionItem instanceof TextSelection ? positionItem.getIndex() + ((TextSelection)positionItem).getText().length() : positionItem.getIndex();
        if (this.repository.containsKey(element)) {
            Vector<Selection> selections = this.repository.get(element);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionIndex) continue;
                selections.get(i).refreshAfterFrontalInsert(item);
            }
        }
    }

    public void unregisterItem(Selection item) {
        OdfElement element = item.getElement();
        if (this.repository.containsKey(element)) {
            Vector<Selection> selections = this.repository.get(element);
            selections.remove(item);
        }
    }

    public synchronized void refresh(OdfElement containerElement, int offset, int positionIndex) {
        if (this.repository.containsKey(containerElement)) {
            Vector<Selection> selections = this.repository.get(containerElement);
            for (int i = 0; i < selections.size(); ++i) {
                if (selections.get(i).getIndex() < positionIndex) continue;
                selections.get(i).refresh(offset);
            }
        }
    }

    public void clearRepository() {
        this.repository.clear();
    }
}

