/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.model.MediaCriteria;
import org.silverpeas.components.gallery.service.MediaServiceProvider;
import org.silverpeas.core.node.model.NodeDetail;

public class AlbumDetail
extends NodeDetail {
    public static final String RESOURCE_TYPE = "Album";
    private static final long serialVersionUID = 1L;
    private MediaCriteria.VISIBILITY mediaVisibility = MediaCriteria.VISIBILITY.BY_DEFAULT;
    private List<Media> media = null;
    private long nbMedia = 0L;

    public AlbumDetail(NodeDetail node) {
        this.setNodePK(node.getNodePK());
        this.setName(node.getName());
        this.setDescription(node.getDescription());
        this.setCreationDate(node.getCreationDate());
        this.setCreatorId(node.getCreatorId());
        this.setPath(node.getPath());
        this.setLevel(node.getLevel());
        this.setStatus(node.getStatus());
        this.setFatherPK(node.getFatherPK());
        this.setChildrenDetails(node.getChildrenDetails());
        this.setNodeType(node.getNodeType());
        this.setOrder(node.getOrder());
        this.setTranslations(node.getTranslations());
    }

    public AlbumDetail(NodeDetail node, MediaCriteria.VISIBILITY mediaVisibility) {
        this(node);
        this.mediaVisibility = mediaVisibility;
    }

    public List<Media> getMedia() {
        if (this.media == null) {
            Collection<Media> allMedia = MediaServiceProvider.getMediaService().getAllMedia(this.getNodePK(), this.mediaVisibility);
            this.setMedia(allMedia);
        }
        return this.media;
    }

    public void setMedia(Collection<Media> media) {
        this.media = new ArrayList<Media>(media);
        if (this.nbMedia == 0L && !media.isEmpty()) {
            this.setNbMedia(this.nbMedia);
        }
    }

    public long getNbMedia() {
        return this.nbMedia;
    }

    public void setNbMedia(long nbMedia) {
        this.nbMedia = nbMedia;
    }

    public Collection<AlbumDetail> getChildrenAlbumsDetails() {
        ArrayList<AlbumDetail> albums = new ArrayList<AlbumDetail>();
        Collection nodes = this.getChildrenDetails();
        if (nodes != null) {
            for (NodeDetail node : nodes) {
                AlbumDetail album = new AlbumDetail(node);
                albums.add(album);
            }
        }
        return albums;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

