/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.autosave;

import java.security.Principal;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.user.autosave.AuthorizableWrapper;
import org.apache.jackrabbit.oak.security.user.autosave.GroupImpl;
import org.apache.jackrabbit.oak.security.user.autosave.UserImpl;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoSaveEnabledManager
implements UserManager {
    private final UserManager dlg;
    private final Root root;
    private boolean autosave = true;

    public AutoSaveEnabledManager(UserManager dlg, Root root) {
        this.dlg = dlg;
        this.root = root;
    }

    public UserManager unwrap() {
        return this.dlg;
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull String id) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizable(id));
    }

    @Nullable
    public <T extends Authorizable> T getAuthorizable(@NotNull String id, @NotNull Class<T> authorizableClass) throws RepositoryException {
        return (T)UserUtil.castAuthorizable((Authorizable)this.wrap(this.dlg.getAuthorizable(id)), authorizableClass);
    }

    @Nullable
    public Authorizable getAuthorizable(@NotNull Principal principal) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizable(principal));
    }

    @Nullable
    public Authorizable getAuthorizableByPath(@NotNull String path) throws RepositoryException {
        return this.wrap(this.dlg.getAuthorizableByPath(path));
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(relPath, value), this);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull String relPath, @Nullable String value, int searchType) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(relPath, value, searchType), this);
    }

    @NotNull
    public Iterator<Authorizable> findAuthorizables(@NotNull Query query) throws RepositoryException {
        return AuthorizableWrapper.createIterator(this.dlg.findAuthorizables(query), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createUser(userID, password));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public User createUser(@NotNull String userID, @Nullable String password, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createUser(userID, password, principal, intermediatePath));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public User createSystemUser(@NotNull String userID, @Nullable String intermediatePath) throws RepositoryException {
        try {
            User user = this.wrap(this.dlg.createSystemUser(userID, intermediatePath));
            return user;
        }
        finally {
            this.autosave();
        }
    }

    @NotNull
    public Group createGroup(@NotNull String groupId) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(groupId));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    @NotNull
    public Group createGroup(@NotNull Principal principal) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(principal));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Group createGroup(@NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(principal, intermediatePath));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Group createGroup(@NotNull String groupID, @NotNull Principal principal, @Nullable String intermediatePath) throws RepositoryException {
        try {
            Group group = this.wrap(this.dlg.createGroup(groupID, principal, intermediatePath));
            return group;
        }
        finally {
            this.autosave();
        }
    }

    public boolean isAutoSave() {
        return this.autosave;
    }

    public void autoSave(boolean enable) {
        this.autosave = enable;
    }

    void autosave() throws RepositoryException {
        if (this.autosave) {
            try {
                this.root.commit();
            }
            catch (CommitFailedException e) {
                throw e.asRepositoryException();
            }
            finally {
                this.root.refresh();
            }
        }
    }

    @Nullable
    Authorizable wrap(@Nullable Authorizable authorizable) {
        if (authorizable == null) {
            return null;
        }
        if (authorizable.isGroup()) {
            return this.wrap((Group)authorizable);
        }
        return this.wrap((User)authorizable);
    }

    @NotNull
    private User wrap(@NotNull User user) {
        return new UserImpl(user, this);
    }

    @NotNull
    private Group wrap(@NotNull Group group) {
        return new GroupImpl(group, this);
    }
}

