/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.model;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.transaction.Transactional;
import org.silverpeas.components.delegatednews.model.DelegatedNews;
import org.silverpeas.components.delegatednews.service.DelegatedNewsService;
import org.silverpeas.components.delegatednews.service.DelegatedNewsServiceProvider;
import org.silverpeas.components.quickinfo.NewsByStatus;
import org.silverpeas.components.quickinfo.QuickInfoComponentSettings;
import org.silverpeas.components.quickinfo.model.News;
import org.silverpeas.components.quickinfo.model.QuickInfoService;
import org.silverpeas.components.quickinfo.notification.NewsEventNotifier;
import org.silverpeas.components.quickinfo.notification.QuickInfoDelayedVisibilityUserNotificationReminder;
import org.silverpeas.components.quickinfo.notification.QuickInfoSubscriptionUserNotification;
import org.silverpeas.components.quickinfo.repository.NewsRepository;
import org.silverpeas.components.quickinfo.service.QuickInfoContentManager;
import org.silverpeas.components.quickinfo.service.QuickInfoDateComparatorDesc;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.admin.component.model.PasteDetail;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.Attachments;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.content.wysiwyg.service.WysiwygController;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.upload.UploadedFile;
import org.silverpeas.core.notification.system.ResourceEvent;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.pdc.subscription.service.PdcSubscriptionManager;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.reminder.Reminder;
import org.silverpeas.core.security.authorization.ComponentAccessControl;
import org.silverpeas.core.silverstatistics.access.service.StatisticService;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

@Service
@Named(value="quickinfoService")
public class DefaultQuickInfoService
implements QuickInfoService {
    private static final String ASSOCIATED_TO_THE_NEWS_MSG = " associated to the news ";
    private static final Predicate<News> VISIBLE_PREDICATE = n -> !n.isDraft() && n.isVisible();
    @Inject
    private NewsRepository newsRepository;
    @Inject
    private QuickInfoContentManager quickInfoContentManager;
    @Inject
    private NewsEventNotifier notifier;
    @Inject
    private PdcManager pdcManager;
    @Inject
    private PdcSubscriptionManager pdcSubscriptionManager;

    @Override
    public Optional<News> getContributionById(ContributionIdentifier contributionId) {
        return Optional.of(this.getNews(contributionId.getLocalId()));
    }

    @Override
    public List<News> getVisibleNews(String componentId) {
        return this.getAllNews(componentId).stream().filter(VISIBLE_PREDICATE).sorted(QuickInfoDateComparatorDesc.comparator).collect(Collectors.toList());
    }

    @Override
    public List<News> getAllNews(String componentId) {
        List<News> allNews = this.newsRepository.getByComponentId(componentId);
        boolean delegateNewsEnabled = this.isDelegatedNewsActivated(componentId);
        this.decorateNews(allNews, delegateNewsEnabled);
        return allNews;
    }

    @Override
    public NewsByStatus getAllNewsByStatus(String componentId, String userId) {
        return new NewsByStatus(this.getAllNews(componentId), userId);
    }

    @Override
    public News getNews(String id) {
        News news = (News)this.newsRepository.getById(id);
        this.decorateNews(Collections.singletonList(news), true);
        return news;
    }

    @Override
    public News getNewsByForeignId(String foreignId) {
        News news = this.newsRepository.getByForeignId(foreignId);
        this.decorateNews(Collections.singletonList(news), true);
        return news;
    }

    @Override
    public void acknowledgeNews(String id, String userId) {
        News news = (News)this.newsRepository.getById(id);
        if (news != null) {
            this.getStatisticService().addStat(userId, (SilverpeasContent)news);
        }
    }

    public SettingBundle getComponentSettings() {
        return QuickInfoComponentSettings.getSettings();
    }

    public LocalizationBundle getComponentMessages(String language) {
        return QuickInfoComponentSettings.getMessagesIn(language);
    }

    public boolean isRelatedTo(String instanceId) {
        return instanceId.startsWith("quickinfo");
    }

    @Override
    @Transactional
    public News create(News news) {
        ResourceReference volatileAttachmentSourceRef = new ResourceReference(news.getPublicationId(), news.getComponentInstanceId());
        PublicationDetail publication = news.getPublication();
        publication.setIndexOperation(-1);
        PublicationPK pubPK = this.getPublicationService().createPublication(publication);
        publication.setPk(pubPK);
        news.setId(null);
        news.setPublicationId(pubPK.getId());
        news.createdBy(publication.getCreatorId());
        News savedNews = (News)this.newsRepository.save((IdentifiableEntity)news);
        List movedDocumentPks = AttachmentServiceProvider.getAttachmentService().moveAllDocuments(volatileAttachmentSourceRef, savedNews.getPublication().getPK().toResourceReference());
        if (!movedDocumentPks.isEmpty()) {
            WysiwygController.wysiwygPlaceHaveChanged((String)news.getComponentInstanceId(), (String)volatileAttachmentSourceRef.getId(), (String)news.getComponentInstanceId(), (String)savedNews.getId());
        }
        try {
            this.quickInfoContentManager.createSilverContent(null, (Contribution)publication, publication.getCreatorId(), false);
        }
        catch (ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error("can not create a silver-content for publication " + publication.getId() + " associated to the saved news " + savedNews.getId(), (Throwable)e);
        }
        return savedNews;
    }

    @Override
    @Transactional
    public News copyNews(News newsToCopy, PasteDetail pasteDetail) {
        News news = News.builder(newsToCopy).build();
        news.setDraft();
        news.setComponentInstanceId(pasteDetail.getToComponentId());
        news.setCreatorId(pasteDetail.getUserId());
        PublicationDetail publication = news.getPublication();
        publication.setIndexOperation(-1);
        PublicationPK pubPK = this.getPublicationService().createPublication(publication);
        publication = this.getPublicationService().getDetail(pubPK);
        news.setPublicationId(pubPK.getId());
        news.setPublication(publication);
        News savedNews = (News)this.newsRepository.save((IdentifiableEntity)news);
        ResourceReference pubSourceRef = newsToCopy.getPublication().getPK().toReference();
        ResourceReference pubDestRef = news.getPublication().getPK().toReference();
        this.copyPdcPositions(newsToCopy, savedNews);
        AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(pubSourceRef, DocumentType.attachment, null).forEach(a -> AttachmentServiceProvider.getAttachmentService().copyDocument(a, pubDestRef));
        WysiwygController.copy((String)pubSourceRef.getComponentInstanceId(), (String)pubSourceRef.getLocalId(), (String)pubDestRef.getComponentInstanceId(), (String)pubDestRef.getLocalId(), (String)pasteDetail.getUserId());
        ThumbnailController.copyThumbnail((ResourceReference)pubSourceRef, (ResourceReference)pubDestRef);
        return savedNews;
    }

    private void copyPdcPositions(News sourceNews, News destNews) {
        String sourceCmpId = sourceNews.getComponentInstanceId();
        String destCmpId = destNews.getComponentInstanceId();
        int sourceId = this.quickInfoContentManager.getOrCreateSilverContentId((Contribution)sourceNews.getPublication());
        int destId = this.quickInfoContentManager.getOrCreateSilverContentId((Contribution)destNews.getPublication());
        try {
            this.pdcManager.copyPositions(sourceId, sourceCmpId, destId, destCmpId);
        }
        catch (PdcException e) {
            SilverLogger.getLogger((Object)this).error("can not copy pdc positions from publication {0} of news {1} to publication {2} of news {3}", new Object[]{sourceNews.getPublication().getPK(), sourceNews.getPK(), destNews.getPublication().getPK(), destNews.getPK()}, (Throwable)e);
        }
    }

    @Override
    @Transactional
    public void publish(String id, String userId) {
        News news = this.getNews(id);
        news.setPublishedBy(userId);
        news.setPublished();
        news.setPublishDate(new Date());
        news.lastUpdatedBy(news.getPublishedBy());
        this.newsRepository.save((IdentifiableEntity)news);
        PublicationDetail publication = news.getPublication();
        this.getPublicationService().setDetail(publication, false);
        try {
            this.quickInfoContentManager.updateSilverContentVisibility((Contribution)publication, true);
        }
        catch (ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error("can not update the silver-content of the publication " + publication.getId() + ASSOCIATED_TO_THE_NEWS_MSG + news.getId(), (Throwable)e);
        }
        this.sendSubscriptionsNotification(news, NotifAction.CREATE);
    }

    @Override
    @Transactional
    public void update(News news, List<PdcPosition> positions, Collection<UploadedFile> uploadedFiles, boolean forcePublishing) {
        News before = (News)((Object)Transaction.performInNew(() -> this.getNews(news.getId())));
        PublicationDetail publication = news.getPublication();
        WysiwygController.save((String)news.getContentToStore(), (String)news.getComponentInstanceId(), (String)news.getPublicationId(), (String)publication.getUpdaterId(), (String)I18NHelper.DEFAULT_LANGUAGE, (boolean)false);
        Attachments.from(uploadedFiles).attachTo((Contribution)news.getPublication());
        if (news.isDraft()) {
            publication.setIndexOperation(-1);
        }
        this.getPublicationService().setDetail(publication);
        news.setPublicationId(publication.getId());
        if (forcePublishing) {
            news.setPublishDate(new Date());
            news.setPublishedBy(news.getLastUpdaterId());
        }
        this.newsRepository.save((IdentifiableEntity)news);
        try {
            this.quickInfoContentManager.updateSilverContentVisibility((Contribution)publication, !news.isDraft());
        }
        catch (ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error("can not update the silver-content of the publication " + publication.getId() + ASSOCIATED_TO_THE_NEWS_MSG + news.getId(), (Throwable)e);
        }
        this.classifyQuickInfo(publication, positions);
        this.notifier.notifyEventOn(ResourceEvent.Type.UPDATE, (Serializable[])new News[]{before, news});
        this.sendSubscriptionsNotification(news, forcePublishing ? NotifAction.CREATE : NotifAction.UPDATE);
    }

    @Override
    @Transactional
    public void removeNews(String id) {
        News news = this.getNews(id);
        PublicationPK foreignPK = news.getForeignPK();
        this.getPublicationService().deletePublication(foreignPK);
        try (Connection connection = DBUtil.openConnection();){
            this.quickInfoContentManager.deleteSilverContent(connection, foreignPK);
        }
        catch (SQLException | ContentManagerException e) {
            SilverLogger.getLogger((Object)this).error("can not delete the silver-content of the publication " + foreignPK.getId() + ASSOCIATED_TO_THE_NEWS_MSG + news.getId(), e);
        }
        this.getStatisticService().deleteStats((SilverpeasContent)news);
        this.newsRepository.deleteById(new String[]{id});
        this.notifier.notifyEventOn(ResourceEvent.Type.DELETION, (Serializable[])new News[]{news});
    }

    @Override
    public List<News> getPlatformNews(String userId) {
        SilverLogger.getLogger((Object)this).debug("Enter Get All Quick Info : User=" + userId, new Object[0]);
        String[] allowedComponentIds = OrganizationController.get().getComponentIdsForUser(userId, "quickinfo");
        int limit = QuickInfoComponentSettings.getSettings().getInteger("news.all.limit", 30);
        return Optional.ofNullable(allowedComponentIds).map(Arrays::asList).filter(Predicate.not(List::isEmpty)).map(this.newsRepository::getByComponentIds).stream().flatMap(Collection::stream).filter(n -> n.getPublishDate() != null).map(n -> {
            this.decorateNews(Collections.singletonList(n), false);
            return n;
        }).filter(VISIBLE_PREDICATE).limit(limit).collect(Collectors.toList());
    }

    @Override
    public List<News> getNewsForTicker(String userId) {
        List<News> tickerNews = this.filterAuthorized(this.newsRepository.getTickerNews(), userId).collect(Collectors.toList());
        if (tickerNews.isEmpty()) {
            return tickerNews;
        }
        this.decorateNews(tickerNews, false);
        return tickerNews.stream().filter(VISIBLE_PREDICATE).sorted(QuickInfoDateComparatorDesc.comparator).collect(Collectors.toList());
    }

    @Override
    public List<News> getUnreadBlockingNews(String userId) {
        List<News> blockingNews = this.filterAuthorized(this.newsRepository.getBlockingNews(), userId).collect(Collectors.toList());
        if (blockingNews.isEmpty()) {
            return blockingNews;
        }
        this.decorateNews(blockingNews, false);
        List visibleNews = blockingNews.stream().filter(VISIBLE_PREDICATE).collect(Collectors.toList());
        Set readNews = this.getStatisticService().filterRead(visibleNews, userId).collect(Collectors.toSet());
        return visibleNews.stream().filter(n -> !readNews.contains(n)).sorted(QuickInfoDateComparatorDesc.comparator).collect(Collectors.toList());
    }

    private Stream<News> filterAuthorized(List<News> news, String userId) {
        Set allInstanceIds = news.stream().map(News::getComponentInstanceId).collect(Collectors.toSet());
        Set authorizedInstanceIds = ComponentAccessControl.get().filterAuthorizedByUser(allInstanceIds, userId).collect(Collectors.toSet());
        return news.stream().filter(n -> authorizedInstanceIds.contains(n.getComponentInstanceId()));
    }

    @Override
    public void submitNewsOnHomepage(String id, String userId) {
        News news = this.getNews(id);
        news.setId(news.getPublicationId());
        this.getDelegatedNewsService().submitNews((Contribution)news, (Period)news.getVisibility().getSpecificPeriod().orElse(null), userId);
    }

    @Override
    public void performReminder(Reminder reminder) {
        if (QuickInfoDelayedVisibilityUserNotificationReminder.QUICKINFO_DELAYED_VISIBILITY_USER_NOTIFICATION.asString().equals(reminder.getProcessName())) {
            this.getContributionById(reminder.getContributionId()).ifPresent(n -> this.sendSubscriptionsNotification((News)((Object)n), NotifAction.CREATE));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendSubscriptionsNotification(News news, NotifAction notifAction) {
        if (news.isDraft()) return;
        if (news.isVisible()) {
            new QuickInfoSubscriptionUserNotification(news, notifAction).build().send();
            try {
                PublicationPK pubPK = news.getPublication().getPK();
                int silverObjectId = this.quickInfoContentManager.getSilverContentId(pubPK.getId(), pubPK.getInstanceId());
                List positions = this.pdcManager.getPositions(silverObjectId, pubPK.getInstanceId());
                if (positions == null) return;
                for (ClassifyPosition position : positions) {
                    this.pdcSubscriptionManager.checkSubscriptions(position.getValues(), pubPK.getInstanceId(), silverObjectId);
                }
                return;
            }
            catch (PdcException e) {
                SilverLogger.getLogger((Object)this).error("PdC subscriber notification failure", (Throwable)e);
                return;
            }
        } else {
            QuickInfoDelayedVisibilityUserNotificationReminder.get().setAbout(news);
        }
    }

    private void classifyQuickInfo(PublicationDetail publi, List<PdcPosition> pdcPositions) {
        if (pdcPositions != null) {
            PdcClassification classification = PdcClassification.aPdcClassificationOfContent((Contribution)publi).withPositions(pdcPositions);
            classification.classifyContentOrClearClassificationIfEmpty((Contribution)publi, false);
        }
    }

    private boolean isDelegatedNewsActivated(String componentId) {
        String paramValue = OrganizationControllerProvider.getOrganisationController().getComponentParameterValue(componentId, "delegatedNews");
        return StringUtil.getBooleanValue((String)paramValue);
    }

    private void decorateNews(List<News> news, boolean delegated) {
        Map<String, News> mapping = this.mapByPublicationId(news);
        this.getPublicationService().getByIds(mapping.keySet()).forEach(p -> {
            News current = (News)((Object)((Object)mapping.get(p.getId())));
            current.setPublication((PublicationDetail)p);
        });
        if (delegated) {
            this.getDelegatedNewsService().getDelegatedNews(mapping.keySet()).forEach(d -> {
                News current = (News)((Object)((Object)mapping.get(d.getId())));
                current.setDelegatedNews((DelegatedNews)d);
            });
        }
    }

    private Map<String, News> mapByPublicationId(List<News> news) {
        HashMap<String, News> mapping = new HashMap<String, News>(news.size());
        news.stream().filter(Objects::nonNull).forEach(n -> mapping.put(n.getPublicationId(), (News)((Object)n)));
        return mapping;
    }

    private PublicationService getPublicationService() {
        return PublicationService.get();
    }

    private StatisticService getStatisticService() {
        return StatisticService.get();
    }

    private DelegatedNewsService getDelegatedNewsService() {
        return DelegatedNewsServiceProvider.getDelegatedNewsService();
    }
}

