/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.service;

import java.io.Serializable;
import java.util.Collection;
import org.silverpeas.core.admin.user.model.SilverpeasRole;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.node.model.NodeDetail;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.util.ArrayUtil;
import org.silverpeas.core.util.URLUtil;

public class KmeliaHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PUBLICATION_HEADER = 0;
    public static final int PUBLICATION_CONTENT = 1;
    public static final int VALIDATION_CLASSIC = 0;
    public static final int VALIDATION_TARGET_1 = 1;
    public static final int VALIDATION_TARGET_N = 2;
    public static final int VALIDATION_COLLEGIATE = 3;
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_PUBLISHER = "publisher";
    public static final String ROLE_WRITER = "writer";
    public static final String ROLE_READER = "user";
    public static final String SPECIALFOLDER_TOVALIDATE = "tovalidate";
    public static final String SPECIALFOLDER_NONVISIBLEPUBS = "notvisibleContributions";

    private KmeliaHelper() {
    }

    public static String getSilverpeasRole(Collection<SilverpeasRole> roles) {
        return KmeliaHelper.getProfile((String[])roles.stream().map(SilverpeasRole::getName).toArray(String[]::new));
    }

    public static String getProfile(String[] profiles) {
        if (ArrayUtil.isEmpty((Object[])profiles)) {
            return null;
        }
        SilverpeasRole flag = SilverpeasRole.USER;
        block6: for (String profile : profiles) {
            SilverpeasRole role = SilverpeasRole.fromString((String)profile);
            switch (role) {
                case ADMIN: {
                    return SilverpeasRole.ADMIN.toString();
                }
                case PUBLISHER: {
                    flag = SilverpeasRole.PUBLISHER;
                    continue block6;
                }
                case WRITER: {
                    if (flag == SilverpeasRole.PUBLISHER) continue block6;
                    flag = SilverpeasRole.WRITER;
                    continue block6;
                }
                case SUPERVISOR: {
                    flag = SilverpeasRole.SUPERVISOR;
                    continue block6;
                }
            }
        }
        return flag.toString();
    }

    public static void checkIndex(PublicationDetail pubDetail) {
        if (KmeliaHelper.isIndexable(pubDetail)) {
            pubDetail.setIndexOperation(0);
        } else {
            pubDetail.setIndexOperation(1);
        }
    }

    public static boolean isIndexable(PublicationDetail pubDetail) {
        return pubDetail.isIndexable();
    }

    public static String extractObjectIdFromURL(String url) {
        return url.substring(url.indexOf("Id=") + 3, url.length());
    }

    public static String extractObjectTypeFromURL(String url) {
        return url.substring(url.indexOf("Type=") + 5, url.lastIndexOf(38));
    }

    public static String getPublicationUrl(PublicationDetail pubDetail, NodePK nodePK) {
        if (pubDetail.isAlias() && nodePK != null) {
            return URLUtil.getSimpleURL((int)2, (String)pubDetail.getPK().getId(), (String)nodePK.getInstanceId(), (boolean)false);
        }
        return URLUtil.getSimpleURL((int)2, (String)pubDetail.getPK().getId(), (boolean)false);
    }

    public static String getNodeUrl(NodeDetail nodeDetail) {
        return URLUtil.getSimpleURL((int)3, (String)nodeDetail.getNodePK().getId(), (String)nodeDetail.getNodePK().getInstanceId(), (boolean)false);
    }

    public static String getDocumentUrl(PublicationDetail pubDetail, SimpleDocument document, String instanceId) {
        return "/Rkmelia/" + instanceId + "/searchResult?Type=Document&Id=" + pubDetail.getId() + "&DocumentId=" + document.getId() + "&FileOpened=0";
    }

    public static boolean isToolbox(String componentId) {
        return componentId.startsWith("toolbox");
    }

    public static boolean isKmax(String componentId) {
        return componentId.startsWith("kmax");
    }

    public static boolean isKmelia(String componentId) {
        return componentId.startsWith("kmelia");
    }

    public static boolean isToValidateFolder(String id) {
        return SPECIALFOLDER_TOVALIDATE.equalsIgnoreCase(id);
    }

    public static boolean isNonVisiblePubsFolder(String id) {
        return SPECIALFOLDER_NONVISIBLEPUBS.equalsIgnoreCase(id);
    }

    public static boolean isSpecialFolder(String id) {
        return KmeliaHelper.isToValidateFolder(id) || KmeliaHelper.isNonVisiblePubsFolder(id);
    }
}

