/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.kmelia.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.silverpeas.components.kmelia.model.KmeliaRuntimeException;
import org.silverpeas.components.kmelia.model.ValidatorsList;
import org.silverpeas.components.kmelia.service.KmeliaHelper;
import org.silverpeas.components.kmelia.service.KmeliaService;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.SilverpeasExceptionMessages;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.comment.model.Comment;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.I18nContribution;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WithThumbnail;
import org.silverpeas.core.contribution.publication.model.CompletePublication;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationPath;
import org.silverpeas.core.contribution.publication.service.PublicationService;
import org.silverpeas.core.i18n.ResourceTranslation;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.silverstatistics.access.service.StatisticService;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.logging.SilverLogger;

public class KmeliaPublication
implements I18nContribution,
SilverpeasContent,
WithPermanentLink,
WithThumbnail {
    private static final long serialVersionUID = 4861635754389280165L;
    private PublicationDetail detail;
    private CompletePublication completeDetail;
    private final PublicationPK pk;
    private boolean read = false;
    private Location location;

    private KmeliaPublication(PublicationPK id) {
        this.pk = id;
    }

    public static KmeliaPublication withPK(PublicationPK pk) {
        KmeliaPublication publication = new KmeliaPublication(pk);
        publication.loadPublicationDetail();
        return publication;
    }

    public static KmeliaPublication withPK(PublicationPK pk, NodePK fatherPk) {
        KmeliaPublication publication = KmeliaPublication.withPK(pk);
        publication.setFather(fatherPk, null);
        return publication;
    }

    private void setFather(NodePK fatherPk, Map<String, List<Location>> locationCache) {
        this.location = this.findLocation(fatherPk, locationCache);
        if (this.location != null) {
            this.getDetail().setAlias(this.location.isAlias());
        }
    }

    private Location findLocation(NodePK pk, Map<String, List<Location>> locationCache) {
        Object nodeIMsg;
        Predicate<Location> predicate;
        if (pk != null) {
            predicate = arg_0 -> ((NodePK)pk).equals(arg_0);
            nodeIMsg = " in node " + pk.getId() + "(Kmelia " + pk.getInstanceId() + ")";
        } else {
            predicate = l -> !l.isAlias();
            nodeIMsg = "";
        }
        PublicationPK mainPubPk = this.getDetail().isClone() ? this.getDetail().getClonePK() : this.getDetail().getPK();
        return this.getAllLocations(mainPubPk, locationCache).stream().filter(predicate).findFirst().orElseGet(() -> this.lambda$findLocation$1(pk, (String)nodeIMsg));
    }

    private Collection<Location> getAllLocations(PublicationPK mainPubPk, Map<String, List<Location>> locationCache) {
        if (locationCache != null) {
            return locationCache.getOrDefault(mainPubPk.getId(), Collections.emptyList());
        }
        return PublicationService.get().getAllLocations(mainPubPk);
    }

    public Location getLocation() {
        if (this.location == null) {
            this.location = this.findLocation(null, null);
        }
        return this.location;
    }

    public static KmeliaPublication fromDetail(PublicationDetail detail) {
        KmeliaPublication publication = new KmeliaPublication(detail.getPK());
        publication.setPublicationDetail(detail);
        return publication;
    }

    public static KmeliaPublication fromDetail(PublicationDetail detail, NodePK fatherPK) {
        return KmeliaPublication.fromDetail(detail, fatherPK, null);
    }

    public static KmeliaPublication fromDetail(PublicationDetail detail, NodePK fatherPK, Map<String, List<Location>> locationCache) {
        KmeliaPublication publication = new KmeliaPublication(detail.getPK());
        publication.setPublicationDetail(detail);
        publication.setFather(fatherPK, locationCache);
        return publication;
    }

    public static KmeliaPublication aKmeliaPublicationFromCompleteDetail(CompletePublication detail) {
        KmeliaPublication publication = new KmeliaPublication(detail.getPublicationDetail().getPK());
        publication.setPublicationCompleteDetail(detail);
        return publication;
    }

    public boolean isRead() {
        return this.read;
    }

    public void setAsRead() {
        this.read = true;
    }

    public boolean isAlias() {
        return this.getDetail().isAlias();
    }

    public boolean isVisible() {
        return this.getDetail().isVisible();
    }

    public PublicationPK getPk() {
        return this.pk;
    }

    public String getId() {
        return this.pk.getId();
    }

    public String getURL() {
        String defaultURL = this.getOrganizationController().getDomain(this.getCreator().getDomainId()).getSilverpeasServerURL();
        String serverURL = ResourceLocator.getGeneralSettingBundle().getString("httpServerBase", defaultURL);
        return serverURL + URLUtil.getSimpleURL((int)2, (String)this.getPk().getId());
    }

    public PublicationDetail getDetail() {
        if (this.detail == null) {
            this.loadPublicationDetail();
        }
        return this.detail;
    }

    public CompletePublication getCompleteDetail() {
        if (this.completeDetail == null) {
            this.setPublicationCompleteDetail(this.getKmeliaService().getCompletePublication(this.pk));
        }
        return this.completeDetail;
    }

    public User getCreator() {
        String creatorId = this.getDetail().getCreatorId();
        return User.getById((String)creatorId);
    }

    public User getLastUpdater() {
        String modifierId = this.getDetail().getUpdaterId();
        User lastModifier = modifierId == null ? this.getCreator() : User.getById((String)modifierId);
        return lastModifier;
    }

    public List<Comment> getComments() {
        return Collections.unmodifiableList(this.getCommentService().getAllCommentsOnResource(PublicationDetail.getResourceType(), new ResourceReference((WAPrimaryKey)this.pk)));
    }

    public List<ClassifyPosition> getPDCPositions() {
        int silverObjectId = this.getKmeliaService().getSilverObjectId(this.pk);
        try {
            return PdcManager.get().getPositions(silverObjectId, this.pk.getInstanceId());
        }
        catch (PdcException e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    public int getNbAccess() {
        try {
            return this.getStatisticService().getCount(new ResourceReference((WAPrimaryKey)this.detail.getPK()), 1, "Publication");
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error((Throwable)e);
            return -1;
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KmeliaPublication other = (KmeliaPublication)obj;
        return Objects.equals(this.pk, other.pk);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.pk != null ? this.pk.hashCode() : 0);
        return hash;
    }

    private void setPublicationDetail(PublicationDetail detail) {
        if (detail == null) {
            throw new KmeliaRuntimeException(SilverpeasExceptionMessages.failureOnGetting((String)"publication detail", (Object)this.getId()));
        }
        this.detail = detail;
    }

    private void setPublicationCompleteDetail(CompletePublication detail) {
        if (this.detail == null) {
            this.setPublicationDetail(detail.getPublicationDetail());
        }
        this.completeDetail = detail;
    }

    private KmeliaService getKmeliaService() {
        try {
            return KmeliaService.get();
        }
        catch (Exception e) {
            throw new KmeliaRuntimeException(e);
        }
    }

    private StatisticService getStatisticService() {
        return StatisticService.get();
    }

    private CommentService getCommentService() {
        return CommentServiceProvider.getCommentService();
    }

    private OrganizationController getOrganizationController() {
        return OrganizationControllerProvider.getOrganisationController();
    }

    private void loadPublicationDetail() {
        this.setPublicationDetail(this.getKmeliaService().getPublicationDetail(this.pk));
    }

    public String getComponentInstanceId() {
        return this.getDetail().getInstanceId();
    }

    public String getSilverpeasContentId() {
        return this.getDetail().getSilverpeasContentId();
    }

    public Date getCreationDate() {
        return this.getDetail().getCreationDate();
    }

    public Date getLastUpdateDate() {
        return this.getDetail().getLastUpdateDate();
    }

    public String getTitle() {
        return this.getDetail().getTitle();
    }

    public String getDescription() {
        return this.getDetail().getDescription();
    }

    public String getContributionType() {
        return this.getDetail().getContributionType();
    }

    public Optional<PublicationPath> getResourcePath() {
        return this.getDetail().getResourcePath();
    }

    public boolean canBeAccessedBy(User user) {
        return this.getDetail().canBeAccessedBy(user);
    }

    public int getNumberOfComments() {
        return this.getCommentService().getCommentsCountOnResource(PublicationDetail.getResourceType(), new ResourceReference((WAPrimaryKey)this.getPk()));
    }

    public Optional<Location> getOriginalLocation(String userId) {
        Location originalLocation = this.findLocation(null, null);
        if (originalLocation != null && NodeAccessControl.get().isUserAuthorized(userId, (Object)originalLocation)) {
            return Optional.of(originalLocation);
        }
        return Optional.empty();
    }

    public ValidatorsList getValidators() {
        return this.getKmeliaService().getAllValidators(this.getPk());
    }

    public String getPermalink() {
        return this.detail.getPermalink();
    }

    public Thumbnail getThumbnail() {
        return this.detail.getThumbnail();
    }

    public ContributionIdentifier getIdentifier() {
        return this.detail.getIdentifier();
    }

    public ResourceTranslation getTranslation(String language) {
        return this.detail.getTranslation(language);
    }

    public ContributionModel getModel() {
        return this.detail.getModel();
    }

    private /* synthetic */ Location lambda$findLocation$1(NodePK pk, String nodeIMsg) {
        if (pk == null || !KmeliaHelper.isKmax(pk.getInstanceId())) {
            throw new KmeliaRuntimeException("Unable to find the location of the publication " + this.getId() + nodeIMsg);
        }
        return null;
    }
}

