/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.util;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.io.FilenameUtils;
import org.silverpeas.core.util.exec.ExternalExecution;
import org.silverpeas.core.util.exec.ExternalExecutionException;
import org.silverpeas.core.viewer.service.SwfToolManager;
import org.silverpeas.core.viewer.service.ViewerException;
import org.silverpeas.kernel.util.StringUtil;

public class SwfUtil
extends ExternalExecution {
    public static final String SWF_DOCUMENT_EXTENSION = "swf";
    public static final String PAGE_FILENAME_SEPARATOR = "-";
    private static final String OUTPUT_COMMAND = "-o";
    private static final String TO_SWF_ENDING_COMMAND = "-f -T 9 -t -s storeallcharacters";

    public static boolean isPdfToSwfActivated() {
        return SwfToolManager.get().isActivated();
    }

    public static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage) {
        SwfUtil.fromPdfToSwf(fileIn, fileOut, oneFilePerPage, null);
    }

    private static void fromPdfToSwf(File fileIn, File fileOut, boolean oneFilePerPage, String endingCommand) {
        File outputFile = fileOut;
        if (oneFilePerPage) {
            StringBuilder onePageFile = new StringBuilder(512);
            onePageFile.append(FilenameUtils.getFullPath((String)fileOut.getPath()));
            onePageFile.append(FilenameUtils.getBaseName((String)fileOut.getPath()));
            onePageFile.append(PAGE_FILENAME_SEPARATOR);
            onePageFile.append("%.");
            onePageFile.append(FilenameUtils.getExtension((String)fileOut.getPath()));
            outputFile = new File(onePageFile.toString());
        }
        try {
            SwfUtil.exec((CommandLine)SwfUtil.buildPdfToSwfCommandLine(endingCommand, fileIn, outputFile));
        }
        catch (ExternalExecutionException e) {
            throw new ViewerException(e);
        }
    }

    static CommandLine buildPdfToSwfCommandLine(String endingCommand, File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("pdf2swf");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArgument(OUTPUT_COMMAND);
        commandLine.addArgument("${outputFile}", false);
        commandLine.addArguments(TO_SWF_ENDING_COMMAND, false);
        if (StringUtil.isDefined((String)endingCommand)) {
            commandLine.addArguments(endingCommand, false);
        }
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }
}

