/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.viewer.service;

import java.io.File;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.io.temp.TemporaryWorkspaceTranslation;
import org.silverpeas.core.viewer.model.ViewerSettings;
import org.silverpeas.kernel.util.StringUtil;

public class ViewerContext {
    private final String documentId;
    private final String documentType;
    private final String originalFileName;
    private final File originalSourceFile;
    private final String language;
    private String initializerProcessName;
    private String uniqueDocumentId = String.valueOf(System.nanoTime());
    private boolean cacheRequired = false;
    private boolean processingCache = false;

    public static ViewerContext from(SimpleDocument document) {
        String contentLanguage = document.getLanguage();
        return new ViewerContext(document.getId(), "attachment", document.getFilename(), new File(document.getAttachmentPath()), contentLanguage).withUniqueDocumentId(contentLanguage + "-" + document.getId());
    }

    public ViewerContext(String documentId, String documentType, String originalFileName, File originalSourceFile, String language) {
        this.documentId = documentId;
        this.documentType = documentType;
        this.originalFileName = originalFileName;
        this.originalSourceFile = originalSourceFile;
        this.language = language;
    }

    private ViewerContext(ViewerContext other) {
        this.documentId = other.documentId;
        this.documentType = other.documentType;
        this.originalFileName = other.originalFileName;
        this.originalSourceFile = other.originalSourceFile;
        this.language = other.language;
        this.initializerProcessName = other.initializerProcessName;
        this.uniqueDocumentId = other.uniqueDocumentId;
        this.cacheRequired = other.cacheRequired;
        this.processingCache = other.processingCache;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public File getOriginalSourceFile() {
        return this.originalSourceFile;
    }

    ViewerContext fromInitializerProcessName(String initializerProcessName) {
        this.initializerProcessName = initializerProcessName;
        return this;
    }

    public TemporaryWorkspaceTranslation getWorkspace() {
        return TemporaryWorkspaceTranslation.from((String)this.getViewId());
    }

    public String getViewId() {
        return this.initializerProcessName + "-" + this.uniqueDocumentId;
    }

    public ViewerContext withUniqueDocumentId(String uniqueDocumentId) {
        if (ViewerSettings.isCacheEnabled() && StringUtil.isDefined((String)uniqueDocumentId)) {
            this.uniqueDocumentId = uniqueDocumentId;
            this.cacheRequired = true;
        }
        return this;
    }

    public boolean isCacheRequired() {
        return this.cacheRequired;
    }

    public boolean isProcessingCache() {
        return this.processingCache;
    }

    public void processingCache() {
        this.processingCache = true;
    }

    public String getLanguage() {
        return this.language;
    }

    protected ViewerContext copy() {
        ViewerContext newViewerContext = new ViewerContext(this);
        newViewerContext.initializerProcessName = "";
        newViewerContext.processingCache = false;
        return newViewerContext;
    }
}

