/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.commons.jaxrs.utilities;

import edu.psu.swe.commons.jaxrs.ErrorMessage;
import edu.psu.swe.commons.jaxrs.exceptions.BackingStoreChangedException;
import edu.psu.swe.commons.jaxrs.exceptions.BadUrlException;
import edu.psu.swe.commons.jaxrs.exceptions.ConflictingDataException;
import edu.psu.swe.commons.jaxrs.exceptions.RestClientException;
import edu.psu.swe.commons.jaxrs.exceptions.RestServerException;
import edu.psu.swe.commons.jaxrs.exceptions.ServiceAuthException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class RestClientUtil {
    private RestClientUtil() {
    }

    public static void checkForSuccess(Response response) throws RestClientException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        if (!RestClientUtil.isSuccessful(response)) {
            int status = response.getStatus();
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SERVER_ERROR) {
                throw new RestServerException(response);
            }
            if (status == 401 || status == 403) {
                throw new ServiceAuthException(response);
            }
            if (status == 409) {
                throw new ConflictingDataException(response);
            }
            if (status == 412) {
                throw new BackingStoreChangedException(response);
            }
            if (status == Response.Status.NOT_FOUND.getStatusCode()) {
                return;
            }
            throw new RestClientException(response);
        }
    }

    public static boolean checkForFourOhFour(WebTarget target, Response response) {
        try {
            RestClientUtil.verifyNotFourOhFour(target, response);
            return false;
        }
        catch (RestClientException e) {
            return true;
        }
    }

    public static void verifyNotFourOhFour(WebTarget target, Response response) throws RestClientException {
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            try {
                ErrorMessage em = (ErrorMessage)response.readEntity(ErrorMessage.class);
                throw new RestClientException(Response.Status.NOT_FOUND.getStatusCode(), em);
            }
            catch (ProcessingException pe) {
                throw new BadUrlException(target.getUri().toASCIIString() + " could not be found");
            }
        }
    }

    public static boolean isSuccessful(Response response) {
        Response.Status.Family responseFamily = response.getStatusInfo().getFamily();
        boolean isSuccessful = responseFamily != Response.Status.Family.CLIENT_ERROR && responseFamily != Response.Status.Family.SERVER_ERROR;
        return isSuccessful;
    }

    public static void close(Response response) {
        try {
            response.close();
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    public static void close(Response response, Consumer<Throwable> consumer) {
        try {
            response.close();
        }
        catch (ProcessingException processingException) {
            consumer.accept(processingException);
        }
    }

    public <T> Optional<T> tryReadEntity(Response response, Class<T> entityType) throws RestClientException, ProcessingException, IllegalStateException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::ofNullable);
    }

    public <T> Optional<T> tryReadEntity(Response response, GenericType<T> entityType) throws RestClientException, ProcessingException, IllegalStateException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::ofNullable);
    }

    public static <T> Optional<T> readEntity(Response response, Class<T> entityType) throws RestClientException, ProcessingException, IllegalStateException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::of);
    }

    public static <T> Optional<T> readEntity(Response response, GenericType<T> entityType) throws RestClientException, ProcessingException, IllegalStateException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        return RestClientUtil.readEntity(response, entityType, arg_0 -> ((Response)response).readEntity(arg_0), Optional::of);
    }

    private static <T, E> Optional<E> readEntity(Response response, T entityType, Function<T, E> readEntity, Function<E, Optional<E>> optionalOf) throws RestClientException, ProcessingException, IllegalStateException, BackingStoreChangedException, ConflictingDataException, ServiceAuthException, RestServerException {
        Optional<Object> result;
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            result = Optional.empty();
        } else {
            RestClientUtil.checkForSuccess(response);
            E responseEntity = readEntity.apply(entityType);
            result = optionalOf.apply(responseEntity);
        }
        return result;
    }

    public static Optional<String> extractIdFromLocationTag(Response response) {
        String location = response.getHeaderString("Location");
        if (location == null) {
            return Optional.empty();
        }
        String[] uriParts = location.split("/");
        Integer nbrParts = uriParts.length;
        return Optional.of(uriParts[nbrParts - 1]);
    }
}

