/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.iri.impl;

import java.net.URI;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactoryI;
import org.apache.jena.iri.impl.IRIFactoryImpl;
import org.apache.jena.iri.impl.IRIImpl;
import org.apache.jena.iri.impl.IRIImplException;

public abstract class AbsIRIFactoryImpl
implements IRIFactoryI {
    protected abstract IRIFactoryImpl getFactory();

    @Override
    public IRI create(String s) {
        return this.create(new IRIImpl(this.getFactory(), s));
    }

    @Override
    public IRI create(URI uri) {
        return this.create(uri.toASCIIString());
    }

    @Override
    public IRI construct(String s) throws IRIException {
        return this.throwAnyErrors(this.create(s));
    }

    @Override
    public IRI construct(IRI i) throws IRIException {
        return this.throwAnyErrors(this.create(i));
    }

    @Override
    public IRI construct(URI uri) throws IRIException {
        return this.throwAnyErrors(this.create(uri));
    }

    protected IRI throwAnyErrors(IRI rslt) throws IRIException {
        if (rslt.hasViolation(false)) {
            throw new IRIImplException(rslt.violations(false).next());
        }
        return rslt;
    }

    @Override
    public abstract IRI create(IRI var1);
}

