/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.gallery.notification.user;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.silverpeas.components.gallery.model.AlbumDetail;
import org.silverpeas.components.gallery.model.Media;
import org.silverpeas.components.gallery.notification.user.AbstractGalleryAlbumUserNotification;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.node.model.NodePK;
import org.silverpeas.core.notification.user.RemoveSenderRecipientBehavior;
import org.silverpeas.core.notification.user.UserSubscriptionNotificationBehavior;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.subscription.SubscriberDirective;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.subscription.constant.SubscriberType;
import org.silverpeas.core.subscription.service.NodeSubscriptionResource;
import org.silverpeas.core.subscription.service.ResourceSubscriptionProvider;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberList;
import org.silverpeas.core.subscription.util.SubscriptionSubscriberMapBySubscriberType;
import org.silverpeas.core.template.SilverpeasTemplate;

public class GalleryAlbumMediaSubscriptionNotificationBuilder
extends AbstractGalleryAlbumUserNotification
implements RemoveSenderRecipientBehavior,
UserSubscriptionNotificationBehavior {
    private final NotifAction notificationCause;
    private SubscriptionSubscriberMapBySubscriberType subscriberIdsByTypes;
    List<Media> concernedMedia = new ArrayList<Media>();

    GalleryAlbumMediaSubscriptionNotificationBuilder(AlbumDetail resource, User sender) {
        super(resource, sender);
        this.notificationCause = NotifAction.POPULATED;
    }

    GalleryAlbumMediaSubscriptionNotificationBuilder aboutMedia(Media ... medias) {
        this.concernedMedia.addAll(Arrays.asList(medias));
        return this;
    }

    @Override
    protected NotifAction getAction() {
        return this.notificationCause;
    }

    protected String getTemplateFileName() {
        return "galleryAlbumMediaAdded";
    }

    @Override
    protected void performTemplateData(String language, AlbumDetail resource, SilverpeasTemplate template) {
        super.performTemplateData(language, resource, template);
        template.setAttribute("severalMedia", (Object)(this.concernedMedia.size() > 1 ? 1 : 0));
    }

    protected Collection<String> getUserIdsToNotify() {
        return ((SubscriptionSubscriberList)this.getSubscriberIdsByTypes().get((Object)SubscriberType.USER)).getAllIds();
    }

    protected Collection<String> getGroupIdsToNotify() {
        return ((SubscriptionSubscriberList)this.getSubscriberIdsByTypes().get((Object)SubscriberType.GROUP)).getAllIds();
    }

    private SubscriptionSubscriberMapBySubscriberType getSubscriberIdsByTypes() {
        if (this.subscriberIdsByTypes == null) {
            this.subscriberIdsByTypes = ResourceSubscriptionProvider.getSubscribersOfSubscriptionResource((SubscriptionResource)NodeSubscriptionResource.from((NodePK)((AlbumDetail)((Object)this.getResource())).getNodePK()), (SubscriberDirective[])new SubscriberDirective[0]).indexBySubscriberType();
        }
        return this.subscriberIdsByTypes;
    }

    protected String getBundleSubjectKey() {
        return "gallery.media.subscription.subject";
    }
}

