/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.secondary;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.guava.common.base.Stopwatch;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.AbstractDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.NodeStateDiffer;
import org.apache.jackrabbit.oak.plugins.document.secondary.DelegatingDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.secondary.PathFilteringDiff;
import org.apache.jackrabbit.oak.plugins.document.secondary.SecondaryStoreRootObserver;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;
import org.apache.jackrabbit.oak.stats.TimerStats;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryStoreObserver
implements Observer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final PathFilter pathFilter;
    private final List<String> metaPropNames;
    private final SecondaryStoreRootObserver secondaryObserver;
    private final NodeStateDiffer differ;
    private final TimerStats local;
    private final TimerStats external;
    private boolean firstEventProcessed;

    public SecondaryStoreObserver(NodeStore nodeStore, List<String> metaPropNames, NodeStateDiffer differ, PathFilter pathFilter, StatisticsProvider statisticsProvider, SecondaryStoreRootObserver secondaryObserver) {
        this.nodeStore = nodeStore;
        this.pathFilter = pathFilter;
        this.secondaryObserver = secondaryObserver;
        this.differ = differ;
        this.metaPropNames = metaPropNames;
        this.local = statisticsProvider.getTimer("DOCUMENT_CACHE_SEC_LOCAL", StatsOptions.DEFAULT);
        this.external = statisticsProvider.getTimer("DOCUMENT_CACHE_SEC_EXTERNAL", StatsOptions.DEFAULT);
    }

    public void contentChanged(@NotNull NodeState root, @NotNull CommitInfo info) {
        if (!this.firstEventProcessed) {
            this.log.info("Starting initial sync");
        }
        Stopwatch w = Stopwatch.createStarted();
        AbstractDocumentNodeState target = (AbstractDocumentNodeState)root;
        NodeState secondaryRoot = this.nodeStore.getRoot();
        NodeState base = DelegatingDocumentNodeState.wrapIfPossible(secondaryRoot, this.differ);
        NodeBuilder builder = secondaryRoot.builder();
        PathFilteringDiff diff = new PathFilteringDiff(builder, this.pathFilter, this.metaPropNames, target);
        PathFilteringDiff.copyMetaProperties(target, builder, this.metaPropNames);
        target.compareAgainstBaseState(base, (NodeStateDiff)diff);
        try {
            NodeState updatedSecondaryRoot = this.nodeStore.merge(builder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
            this.secondaryObserver.contentChanged(DelegatingDocumentNodeState.wrap(updatedSecondaryRoot, this.differ));
            TimerStats timer = info.isExternal() ? this.external : this.local;
            timer.update(w.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
            if (!this.firstEventProcessed) {
                this.log.info("Time taken for initial sync {}", (Object)w);
                this.firstEventProcessed = true;
            }
        }
        catch (CommitFailedException e) {
            this.log.warn("Commit to secondary store failed", (Throwable)e);
        }
    }
}

