/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.document.FailedWithConflictException;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.jetbrains.annotations.NotNull;

class ConflictException
extends Exception {
    private static final long serialVersionUID = 1418838561903727231L;
    private final Set<Revision> conflictRevisions;

    ConflictException(@NotNull String message, @NotNull Revision conflictRevision) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = Collections.singleton((Revision)Preconditions.checkNotNull((Object)conflictRevision));
    }

    ConflictException(@NotNull String message, @NotNull Set<Revision> conflictRevisions) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = (Set)Preconditions.checkNotNull(conflictRevisions);
    }

    ConflictException(@NotNull String message) {
        super((String)Preconditions.checkNotNull((Object)message));
        this.conflictRevisions = Collections.emptySet();
    }

    CommitFailedException asCommitFailedException() {
        if (!this.conflictRevisions.isEmpty()) {
            return new FailedWithConflictException(this.conflictRevisions, this.getMessage(), this);
        }
        return new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying store", (Throwable)this);
    }

    @NotNull
    Iterable<Revision> getConflictRevisions() {
        return this.conflictRevisions;
    }
}

