/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.oak.security.authorization.permission.PermissionEntry;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeBits;

final class ReadStatus {
    private static final int THIS = 1;
    private static final int PROPERTIES = 2;
    private static final int CHILD_NODES = 4;
    private static final int THIS_PROPERTIES = 3;
    private static final int ALL = 7;
    private static final ReadStatus ALLOW_THIS = new ReadStatus(1, true);
    private static final ReadStatus ALLOW_THIS_PROPERTIES = new ReadStatus(3, true);
    static final ReadStatus ALLOW_ALL = new ReadStatus(7, true);
    static final ReadStatus DENY_THIS = new ReadStatus(1, false);
    private static final ReadStatus DENY_THIS_PROPERTIES = new ReadStatus(3, false);
    static final ReadStatus DENY_ALL = new ReadStatus(7, false);
    private static final PrivilegeBits READ_BITS = (PrivilegeBits)PrivilegeBits.BUILT_IN.get("jcr:read");
    private static final PrivilegeBits READ_PROPERTIES_BITS = (PrivilegeBits)PrivilegeBits.BUILT_IN.get("rep:readProperties");
    private final int status;
    private final boolean isAllow;

    private ReadStatus(int status, boolean isAllow) {
        this.status = status;
        this.isAllow = isAllow;
    }

    static ReadStatus create(PermissionEntry pe, long permission, boolean skipped) {
        if (skipped || permission == 128L || pe.restriction != RestrictionPattern.EMPTY) {
            return pe.isAllow ? ALLOW_THIS : DENY_THIS;
        }
        if (pe.privilegeBits.includes(READ_BITS)) {
            return pe.isAllow ? ALLOW_ALL : DENY_ALL;
        }
        if (pe.privilegeBits.includes(READ_PROPERTIES_BITS)) {
            return pe.isAllow ? ALLOW_THIS_PROPERTIES : DENY_THIS_PROPERTIES;
        }
        return pe.isAllow ? ALLOW_THIS : DENY_THIS;
    }

    boolean allowsThis() {
        return this.isAllow && (this.status & 1) == 1;
    }

    boolean allowsProperties() {
        return this.isAllow && (this.status & 2) == 2;
    }

    boolean allowsAll() {
        return false;
    }
}

