/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.store;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MalformedObjectNameException;
import org.apache.jackrabbit.oak.segment.standby.jmx.ObservablePartnerMBean;
import org.jetbrains.annotations.NotNull;

class CommunicationPartnerMBean
implements ObservablePartnerMBean {
    private final String clientName;
    private final String remoteAddress;
    private final int remotePort;
    private final AtomicLong segmentsSent = new AtomicLong();
    private final AtomicLong segmentBytesSent = new AtomicLong();
    private final AtomicLong binariesSent = new AtomicLong();
    private final AtomicLong binariesBytesSent = new AtomicLong();
    private volatile String lastRequest;
    private volatile Date lastSeen;

    CommunicationPartnerMBean(String clientName, String remoteAddress, int remotePort) throws MalformedObjectNameException {
        this.clientName = clientName;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
    }

    @Override
    @NotNull
    public String getName() {
        return this.clientName;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public String getLastRequest() {
        return this.lastRequest;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getLastSeenTimestamp() {
        return this.lastSeen.toString();
    }

    @Override
    public long getTransferredSegments() {
        return this.segmentsSent.get();
    }

    @Override
    public long getTransferredSegmentBytes() {
        return this.segmentBytesSent.get();
    }

    @Override
    public long getTransferredBinaries() {
        return this.binariesSent.get();
    }

    @Override
    public long getTransferredBinariesBytes() {
        return this.binariesBytesSent.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMessageReceived(Date lastSeen, String lastRequest) {
        CommunicationPartnerMBean communicationPartnerMBean = this;
        synchronized (communicationPartnerMBean) {
            this.lastSeen = lastSeen;
            this.lastRequest = lastRequest;
        }
    }

    void onSegmentSent(long bytes) {
        this.segmentsSent.incrementAndGet();
        this.segmentBytesSent.addAndGet(bytes);
    }

    void onBinarySent(long bytes) {
        this.binariesSent.incrementAndGet();
        this.binariesBytesSent.addAndGet(bytes);
    }

    Date getLastSeen() {
        return this.lastSeen;
    }
}

