/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Comparator;
import org.apache.jackrabbit.oak.plugins.document.ClusterNodeInfo;

class ClusterNodeInfoComparator
implements Comparator<ClusterNodeInfo> {
    private static final Comparator<Boolean> BOOLEAN_REVERSED = Comparator.comparing(Boolean::booleanValue).reversed();
    private final String machineId;
    private final String instanceId;

    ClusterNodeInfoComparator(String machineId, String instanceId) {
        this.machineId = machineId;
        this.instanceId = instanceId;
    }

    @Override
    public int compare(ClusterNodeInfo info1, ClusterNodeInfo info2) {
        return Comparator.comparing(this::matchesEnvironment, BOOLEAN_REVERSED).thenComparingInt(ClusterNodeInfo::getId).compare(info1, info2);
    }

    private boolean matchesEnvironment(ClusterNodeInfo info) {
        return this.machineId.equals(info.getMachineId()) && this.instanceId.equals(info.getInstanceId());
    }
}

