/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.composite;

import java.security.Principal;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.security.AccessControlManager;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositeAccessControlManager;
import org.apache.jackrabbit.oak.security.authorization.composite.CompositePermissionProvider;
import org.apache.jackrabbit.oak.spi.security.CompositeConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregatedPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.AggregationFilter;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.EmptyPermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeAuthorizationConfiguration
extends CompositeConfiguration<AuthorizationConfiguration>
implements AuthorizationConfiguration {
    private static final Logger log = LoggerFactory.getLogger(CompositeAuthorizationConfiguration.class);
    private CompositionType compositionType = CompositionType.AND;
    private AggregationFilter aggregationFilter = AggregationFilter.DEFAULT;

    public CompositeAuthorizationConfiguration() {
        super("org.apache.jackrabbit.oak.authorization");
    }

    public CompositeAuthorizationConfiguration(@NotNull SecurityProvider securityProvider) {
        super("org.apache.jackrabbit.oak.authorization", securityProvider);
    }

    public void withCompositionType(@Nullable String ct) {
        this.compositionType = CompositionType.fromString(ct);
    }

    public void withAggregationFilter(@NotNull AggregationFilter aggregationFilter) {
        this.aggregationFilter = aggregationFilter;
    }

    @NotNull
    public AccessControlManager getAccessControlManager(@NotNull Root root, @NotNull NamePathMapper namePathMapper) {
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return ((AuthorizationConfiguration)configurations.get(0)).getAccessControlManager(root, namePathMapper);
            }
        }
        List mgrs = Lists.transform((List)configurations, authorizationConfiguration -> authorizationConfiguration.getAccessControlManager(root, namePathMapper));
        return new CompositeAccessControlManager(root, namePathMapper, this.getSecurityProvider(), mgrs, this.aggregationFilter);
    }

    @NotNull
    public RestrictionProvider getRestrictionProvider() {
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                return RestrictionProvider.EMPTY;
            }
            case 1: {
                return ((AuthorizationConfiguration)configurations.get(0)).getRestrictionProvider();
            }
        }
        LinkedHashSet<RestrictionProvider> rps = new LinkedHashSet<RestrictionProvider>(configurations.size());
        for (AuthorizationConfiguration c : configurations) {
            RestrictionProvider rp = c.getRestrictionProvider();
            if (RestrictionProvider.EMPTY == rp) continue;
            rps.add(rp);
        }
        return CompositeRestrictionProvider.newInstance(rps);
    }

    @NotNull
    public PermissionProvider getPermissionProvider(@NotNull Root root, @NotNull String workspaceName, @NotNull Set<Principal> principals) {
        Object pp;
        List configurations = this.getConfigurations();
        switch (configurations.size()) {
            case 0: {
                throw new IllegalStateException();
            }
            case 1: {
                return ((AuthorizationConfiguration)configurations.get(0)).getPermissionProvider(root, workspaceName, principals);
            }
        }
        ArrayList<AggregatedPermissionProvider> aggrPermissionProviders = new ArrayList<AggregatedPermissionProvider>(configurations.size());
        for (AuthorizationConfiguration conf : configurations) {
            PermissionProvider pProvider = conf.getPermissionProvider(root, workspaceName, principals);
            if (pProvider instanceof AggregatedPermissionProvider) {
                AggregatedPermissionProvider aggrProvider = (AggregatedPermissionProvider)pProvider;
                aggrPermissionProviders.add(aggrProvider);
                if (!this.aggregationFilter.stop(aggrProvider, principals)) continue;
                break;
            }
            log.debug("Ignoring permission provider of '{}': Not an AggregatedPermissionProvider", (Object)conf.getClass().getName());
        }
        switch (aggrPermissionProviders.size()) {
            case 0: {
                pp = EmptyPermissionProvider.getInstance();
                break;
            }
            case 1: {
                pp = (PermissionProvider)aggrPermissionProviders.get(0);
                break;
            }
            default: {
                pp = CompositePermissionProvider.create(root, aggrPermissionProviders, this.getContext(), this.compositionType, this.getRootProvider(), this.getTreeProvider());
            }
        }
        return pp;
    }

    public static enum CompositionType {
        AND,
        OR;


        static CompositionType fromString(@Nullable String type) {
            String or = OR.name();
            if (or.equals(type) || or.toLowerCase().equals(type)) {
                return OR;
            }
            return AND;
        }
    }
}

