/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.websites.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.persistence.EntityNotFoundException;
import org.silverpeas.components.websites.model.IconDetail;
import org.silverpeas.components.websites.model.SiteDetail;
import org.silverpeas.components.websites.model.SiteDetailBuilder;
import org.silverpeas.components.websites.model.SitePK;
import org.silverpeas.core.persistence.jdbc.DBUtil;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.kernel.logging.SilverLogger;

public class SiteDAO {
    private Connection dbConnection;
    private static final String WHERE_SITE_ID_CLAUSE = " where siteId = ?";
    private static final String RESULT_COUNT_MSG_PART = ": result count = ";
    private static final String TABLE_SITE_NAME = "SC_WebSites_Site";
    private static final String TABLE_ICONS_NAME = "SC_WebSites_Icons";
    private static final String TABLE_SITE_ICONS_NAME = "SC_WebSites_SiteIcons";
    private static final String TABLE_PUBLICATION_NAME = "SB_Publication_Publi";
    private final String componentId;

    public SiteDAO(String componentId) {
        this.componentId = componentId;
    }

    private Connection openConnection() throws SQLException {
        return DBUtil.openConnection();
    }

    private void closeConnection(Connection dbConnect) {
        try {
            dbConnect.close();
        }
        catch (SQLException se) {
            SilverLogger.getLogger((Object)this).error((Throwable)se);
        }
    }

    public String getIdPublication(String siteId) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            String string = this.daoGetIdPublication(siteId);
            return string;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public Collection<SiteDetail> getAllWebSite() throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            Collection<SiteDetail> collection = this.daoGetAllWebSite();
            return collection;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public SiteDetail getWebSite(SitePK pk) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            SiteDetail siteDetail = this.daoGetWebSite(pk);
            return siteDetail;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public List<SiteDetail> getWebSites(List<String> siteIds) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            List<SiteDetail> list = this.daoGetWebSites(siteIds);
            return list;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public Collection<IconDetail> getIcons(SitePK pk) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            Collection<IconDetail> collection = this.daoGetIcons(pk);
            return collection;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public String getNextId() throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            String string = this.daoGetNextId();
            return string;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public Collection<IconDetail> getAllIcons() throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            Collection<IconDetail> collection = this.daoGetAllIcons();
            return collection;
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void createWebSite(SiteDetail description) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoCreateWebSite(description);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void associateIcons(String id, Collection<String> iconIds) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoAssociateIcons(id, iconIds);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void publish(Collection<String> siteIds) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoPublish(siteIds);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void dePublish(Collection<String> siteIds) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoDePublish(siteIds);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void deleteWebSites(Collection<String> siteIds) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoDeleteWebSites(siteIds);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    public void deleteAllWebSites() throws SQLException {
        String siteIcons = "DELETE FROM SC_WebSites_SiteIcons WHERE siteId in (SELECT siteId FROM SC_WebSites_Site WHERE instanceId = ?)";
        String sites = "DELETE FROM SC_WebSites_Site WHERE instanceId =?";
        try (Connection connection = this.openConnection();){
            try (PreparedStatement deletion = connection.prepareStatement("DELETE FROM SC_WebSites_SiteIcons WHERE siteId in (SELECT siteId FROM SC_WebSites_Site WHERE instanceId = ?)");){
                deletion.setString(1, this.componentId);
                deletion.execute();
            }
            deletion = connection.prepareStatement("DELETE FROM SC_WebSites_Site WHERE instanceId =?");
            try {
                deletion.setString(1, this.componentId);
                deletion.execute();
            }
            finally {
                if (deletion != null) {
                    deletion.close();
                }
            }
        }
    }

    public void updateWebSite(SiteDetail description) throws SQLException {
        try {
            this.dbConnection = this.openConnection();
            this.daoUpdateWebSite(description);
        }
        finally {
            this.closeConnection(this.dbConnection);
        }
    }

    private String daoGetIdPublication(String siteId) throws SQLException {
        String idPub = null;
        String queryStr1 = "select pubId from SB_Publication_Publi where instanceId = ? AND pubVersion = ?";
        try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr1);){
            stmt.setString(1, this.componentId);
            stmt.setString(2, siteId);
            try (ResultSet rs1 = stmt.executeQuery();){
                if (rs1.next()) {
                    idPub = Integer.toString(rs1.getInt(1));
                }
            }
        }
        return idPub;
    }

    private Collection<SiteDetail> daoGetAllWebSite() throws SQLException {
        ArrayList<SiteDetail> theSiteList = new ArrayList<SiteDetail>();
        String queryStr1 = "SELECT siteId, siteName, siteDescription, sitePage, siteType, siteAuthor, siteDate, siteState, popup FROM SC_WebSites_Site where instanceId = ? order by siteid";
        try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr1);){
            stmt.setString(1, this.componentId);
            try (ResultSet rs1 = stmt.executeQuery();){
                while (rs1.next()) {
                    SiteDetail sitedetail = this.getSiteDetail(rs1);
                    theSiteList.add(sitedetail);
                }
            }
        }
        return theSiteList;
    }

    private SiteDetail daoGetWebSite(SitePK pk) throws SQLException {
        SiteDetail sitedetail;
        block13: {
            String queryStr1 = "select siteId, siteName, siteDescription, sitePage, siteType, siteAuthor, siteDate, siteState, popup from SC_WebSites_Site where siteId = ?";
            try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr1);){
                stmt.setInt(1, Integer.parseInt(pk.getId()));
                try (ResultSet rs1 = stmt.executeQuery();){
                    if (rs1.next()) {
                        sitedetail = this.getSiteDetail(rs1);
                        break block13;
                    }
                    throw new EntityNotFoundException("No site found with id " + pk.getId());
                }
            }
        }
        return sitedetail;
    }

    @Nonnull
    private SiteDetail getSiteDetail(ResultSet rs1) throws SQLException {
        String idSite = Integer.toString(rs1.getInt(1));
        String name = rs1.getString(2);
        String description = rs1.getString(3);
        String page = rs1.getString(4);
        int type = rs1.getInt(5);
        String author = rs1.getString(6);
        String date = rs1.getString(7);
        int state = rs1.getInt(8);
        int popup = rs1.getInt(9);
        SiteDetail sitedetail = new SiteDetailBuilder().setSiteId(idSite).setApplicationId(this.componentId).setName(name).setDescription(description).setPage(page).setType(type).setCreatorId(author).setDate(date).setState(state).setPopup(popup).createSiteDetail();
        return sitedetail;
    }

    private List<SiteDetail> daoGetWebSites(List<String> siteIds) throws SQLException {
        ArrayList<SiteDetail> theSiteList = new ArrayList<SiteDetail>();
        StringBuilder paramBuffer = new StringBuilder();
        for (int i = 0; i < siteIds.size(); ++i) {
            String param = paramBuffer.length() == 0 ? " siteId = ?" : " or siteId = ?";
            paramBuffer.append(param);
        }
        if (!siteIds.isEmpty()) {
            String queryStr1 = "select siteId, siteName, siteDescription, sitePage, siteType, siteAuthor, siteDate, siteState, popup from SC_WebSites_Site where (" + paramBuffer + ") and instanceId = ?";
            try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr1);){
                int i;
                for (i = 0; i < siteIds.size(); ++i) {
                    stmt.setInt(i + 1, Integer.parseInt(siteIds.get(i)));
                }
                stmt.setString(i + 1, this.componentId);
                try (ResultSet rs = stmt.executeQuery();){
                    while (rs.next()) {
                        int j = 1;
                        String idSite = Integer.toString(rs.getInt(j++));
                        String name = rs.getString(j++);
                        String description = rs.getString(j++);
                        String page = rs.getString(j++);
                        int type = rs.getInt(j++);
                        String author = rs.getString(j++);
                        String date = rs.getString(j++);
                        int state = rs.getInt(j++);
                        int popup = rs.getInt(j);
                        theSiteList.add(new SiteDetailBuilder().setSiteId(idSite).setApplicationId(this.componentId).setName(name).setDescription(description).setPage(page).setType(type).setCreatorId(author).setDate(date).setState(state).setPopup(popup).createSiteDetail());
                    }
                }
            }
        }
        return theSiteList;
    }

    private Collection<IconDetail> daoGetIcons(SitePK pk) throws SQLException {
        StringBuilder queryStr1 = new StringBuilder();
        queryStr1.append("select ").append(TABLE_ICONS_NAME).append(".iconsId, ").append(TABLE_ICONS_NAME).append(".iconsName, ").append(TABLE_ICONS_NAME).append(".iconsDescription, ").append(TABLE_ICONS_NAME).append(".iconsAddress");
        queryStr1.append(" from ").append(TABLE_SITE_ICONS_NAME).append(", ").append(TABLE_ICONS_NAME);
        queryStr1.append(" where ").append(TABLE_SITE_ICONS_NAME).append(".siteId = ").append(pk.getId());
        queryStr1.append(" and ").append(TABLE_ICONS_NAME).append(".iconsId = ").append(TABLE_SITE_ICONS_NAME).append(".iconsId");
        return this.executeQuery(queryStr1.toString());
    }

    private List<IconDetail> executeQuery(String query) throws SQLException {
        ArrayList<IconDetail> result = new ArrayList<IconDetail>();
        try (Statement stmt = this.dbConnection.createStatement();
             ResultSet rs = stmt.executeQuery(query);){
            while (rs.next()) {
                String idIcon = Integer.toString(rs.getInt(1));
                String name = rs.getString(2);
                String description = rs.getString(3);
                String address = rs.getString(4);
                IconDetail icondetail = new IconDetail(idIcon, name, description, address);
                result.add(icondetail);
            }
        }
        return result;
    }

    private String daoGetNextId() {
        int nextid = DBUtil.getNextId((String)TABLE_SITE_NAME, (String)"siteId");
        return Integer.toString(nextid);
    }

    private Collection<IconDetail> daoGetAllIcons() throws SQLException {
        String queryStr1 = "SELECT iconsId, iconsName, iconsDescription, iconsAddress FROM SC_WebSites_Icons";
        return this.executeQuery(queryStr1);
    }

    private void daoCreateWebSite(SiteDetail site) throws SQLException {
        String queryStr = "insert into SC_WebSites_Site values (?,?,?,?,?,?,?,?,?,?)";
        try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr);){
            stmt.setInt(1, Integer.parseInt(site.getSitePK().getId()));
            stmt.setString(2, site.getName());
            stmt.setString(3, site.getDescription());
            stmt.setString(4, site.getContentPagePath());
            stmt.setInt(5, site.getSiteType());
            stmt.setString(6, site.getCreatorId());
            stmt.setString(7, DateUtil.date2SQLDate((Date)site.getCreationDate()));
            stmt.setInt(8, site.getState());
            stmt.setString(9, this.componentId);
            stmt.setInt(10, site.getPopup());
            int resultCount = stmt.executeUpdate();
            if (resultCount != 1) {
                SilverLogger.getLogger((Object)this).error("Cannot save data with query " + queryStr + RESULT_COUNT_MSG_PART + resultCount, new Object[0]);
            }
        }
    }

    private void daoAssociateIcons(String id, Collection<String> iconIds) throws SQLException {
        String queryStr = "INSERT INTO SC_WebSites_SiteIcons VALUES (?,?)";
        try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr);){
            stmt.setInt(1, Integer.parseInt(id));
            for (String iconId : iconIds) {
                stmt.setInt(2, Integer.parseInt(iconId));
                int resultCount = stmt.executeUpdate();
                if (resultCount == 1) continue;
                SilverLogger.getLogger((Object)this).error("Cannot save data with query " + queryStr + RESULT_COUNT_MSG_PART + resultCount, new Object[0]);
            }
        }
    }

    private void daoPublishDepublishSite(String id, int state) throws SQLException {
        String queryStr = "update SC_WebSites_Site set siteState=? where siteId= ?";
        try (PreparedStatement stmt = this.dbConnection.prepareStatement(queryStr);){
            stmt.setInt(1, state);
            stmt.setInt(2, Integer.parseInt(id));
            int resultCount = stmt.executeUpdate();
            if (resultCount != 1) {
                SilverLogger.getLogger((Object)this).error("Cannot update data with query " + queryStr + RESULT_COUNT_MSG_PART + resultCount, new Object[0]);
            }
        }
    }

    private void daoPublish(Collection<String> siteIds) throws SQLException {
        for (String id : siteIds) {
            this.daoPublishDepublishSite(id, 1);
        }
    }

    private void daoDePublish(Collection<String> siteIds) throws SQLException {
        for (String id : siteIds) {
            this.daoPublishDepublishSite(id, 0);
        }
    }

    private void daoDeleteAssociateIcons(SitePK pk) throws SQLException {
        String deleteStr = "delete from SC_WebSites_SiteIcons where siteId = ?";
        try (PreparedStatement prepStmt = this.dbConnection.prepareStatement(deleteStr);){
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            prepStmt.executeUpdate();
        }
    }

    private void daoDeleteWebSite(SitePK pk) throws SQLException {
        this.daoDeleteAssociateIcons(pk);
        String deleteStr = "delete from SC_WebSites_Site where siteId = ?";
        try (PreparedStatement prepStmt = this.dbConnection.prepareStatement(deleteStr);){
            prepStmt.setInt(1, Integer.parseInt(pk.getId()));
            int resultCount = prepStmt.executeUpdate();
            if (resultCount != 1) {
                SilverLogger.getLogger((Object)this).error("Cannot delete data with query " + deleteStr + RESULT_COUNT_MSG_PART + resultCount, new Object[0]);
            }
        }
    }

    private void daoDeleteWebSites(Collection<String> siteIds) throws SQLException {
        ArrayList<String> array = new ArrayList<String>(siteIds);
        for (int i = 0; i < array.size(); ++i) {
            String id = array.get(i);
            SitePK s = new SitePK(id, this.componentId);
            this.daoDeleteWebSite(s);
        }
    }

    private void daoUpdateWebSite(SiteDetail description) throws SQLException {
        this.daoDeleteAssociateIcons(description.getSitePK());
        String updateStr = "update SC_WebSites_Site set siteName = ?, siteDescription = ?, sitePage = ?, siteAuthor = ?, siteDate = ?, siteState = ?, popup = ?  where siteId = ?";
        try (PreparedStatement prepStmt = this.dbConnection.prepareStatement(updateStr);){
            int i = 1;
            prepStmt.setString(i++, description.getName());
            prepStmt.setString(i++, description.getDescription());
            prepStmt.setString(i++, description.getContentPagePath());
            prepStmt.setString(i++, description.getCreatorId());
            prepStmt.setString(i++, DateUtil.date2SQLDate((Date)description.getCreationDate()));
            prepStmt.setInt(i++, description.getState());
            prepStmt.setInt(i++, description.getPopup());
            prepStmt.setInt(i, Integer.parseInt(description.getSitePK().getId()));
            int resultCount = prepStmt.executeUpdate();
            if (resultCount != 1) {
                SilverLogger.getLogger((Object)this).error("Cannot update site " + description.toString() + " with query " + updateStr + RESULT_COUNT_MSG_PART + resultCount, new Object[0]);
            }
        }
    }
}

