/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.resourcesmanager.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.silverpeas.components.resourcesmanager.model.Category;
import org.silverpeas.components.resourcesmanager.model.ResourceValidator;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sc_resources_resource")
@NamedQueries(value={@NamedQuery(name="resource.findAllResourcesByCategory", query="SELECT resource FROM Resource resource WHERE resource.category.id = :categoryId"), @NamedQuery(name="resource.findAllBookableResources", query="SELECT resource FROM Resource resource WHERE resource.instanceId = :instanceId AND resource.bookable = 1 AND resource.category.bookable = 1 ORDER BY resource.name"), @NamedQuery(name="resource.findAllResources", query="SELECT resource FROM Resource resource WHERE resource.instanceId = :instanceId ORDER BY resource.name"), @NamedQuery(name="resource.deleteResourcesFromCategory", query="DELETE FROM Resource resource WHERE resource.category.id = :categoryId")})
public class Resource
extends BasicJpaEntity<Resource, UniqueLongIdentifier> {
    private static final long serialVersionUID = 3438059589840347315L;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="categoryid")
    private Category category;
    @Column
    private String name;
    @Column
    private String creationDate;
    @Column
    private String updateDate;
    @Column
    private Integer bookable;
    @Column
    private String description;
    @Column
    private String createrId;
    @Column
    private String updaterId;
    @Column
    private String instanceId;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="resource", fetch=FetchType.EAGER)
    private List<ResourceValidator> managers = new ArrayList<ResourceValidator>();
    @Transient
    private String status;

    protected void performBeforePersist() {
        Date now = new Date();
        this.setCreationDate(now);
        this.setUpdateDate(now);
    }

    public void performBeforeUpdate() {
        this.setUpdateDate(new Date());
    }

    public boolean isBookable() {
        return this.bookable == 1;
    }

    public void setBookable(boolean bookable) {
        this.bookable = bookable ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public String getCreaterId() {
        return this.createrId;
    }

    public void setCreaterId(String createrId) {
        this.createrId = createrId;
    }

    public Date getCreationDate() {
        if (StringUtil.isLong((String)this.creationDate)) {
            Date create = new Date();
            create.setTime(Long.parseLong(this.creationDate));
            return create;
        }
        return null;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = String.valueOf(creationDate.getTime());
    }

    public Date getUpdateDate() {
        if (StringUtil.isLong((String)this.updateDate)) {
            Date update = new Date();
            update.setTime(Long.parseLong(this.updateDate));
            return update;
        }
        return null;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = String.valueOf(updateDate.getTime());
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getIdAsLong() {
        return ((UniqueLongIdentifier)this.getNativeId()).getId();
    }

    public String getIdAsString() {
        return this.getId();
    }

    public Long getCategoryId() {
        if (this.category != null) {
            return this.category.getIdAsLong();
        }
        return null;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUpdaterId() {
        return this.updaterId;
    }

    public void setUpdaterId(String updaterId) {
        this.updaterId = updaterId;
    }

    public List<ResourceValidator> getManagers() {
        return this.managers;
    }

    public void setManagers(List<ResourceValidator> managers) {
        this.managers.clear();
        this.managers.addAll(managers);
    }

    public void merge(Resource resource) {
        this.bookable = resource.bookable;
        this.category = resource.category;
        this.createrId = resource.createrId;
        this.creationDate = resource.creationDate;
        this.description = resource.description;
        this.instanceId = resource.instanceId;
        this.name = resource.name;
        this.updateDate = resource.updateDate;
        this.updaterId = resource.updaterId;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Resource other = (Resource)((Object)obj);
        EqualsBuilder matcher = new EqualsBuilder();
        matcher.append((Object)this.getId(), (Object)other.getId());
        matcher.append((Object)this.getCategory(), (Object)other.getCategory());
        matcher.append((Object)this.getName(), (Object)other.getName());
        matcher.append(this.isBookable(), other.isBookable());
        matcher.append((Object)this.getDescription(), (Object)other.getDescription());
        matcher.append((Object)this.getCreaterId(), (Object)other.getCreaterId());
        matcher.append((Object)this.getUpdaterId(), (Object)other.getUpdaterId());
        matcher.append((Object)this.getInstanceId(), (Object)other.getInstanceId());
        return matcher.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hash = new HashCodeBuilder();
        hash.append((Object)this.getId());
        hash.append((Object)this.getCategory());
        hash.append((Object)this.getName());
        hash.append(this.isBookable());
        hash.append((Object)this.getDescription());
        hash.append((Object)this.getCreaterId());
        hash.append((Object)this.getUpdaterId());
        hash.append((Object)this.getInstanceId());
        return hash.toHashCode();
    }

    public String toString() {
        return "Resource{id=" + this.getId() + ", category= {" + this.category + "}, name=" + this.name + ", creationDate=" + this.creationDate + ", updateDate=" + this.updateDate + ", description=" + this.description + ", createrId=" + this.createrId + ", updaterId=" + this.updaterId + ", instanceId=" + this.instanceId + ", bookable=" + this.bookable + ", managers=" + this.managers + ", status=" + this.getStatus() + "}";
    }

    public boolean isValidated() {
        return "V".equals(this.getStatus());
    }

    public boolean isRefused() {
        return "R".equals(this.getStatus());
    }

    public boolean isValidationRequired() {
        return "A".equals(this.getStatus());
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }
}

