/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionablePropertiesEditor
extends DefaultEditor {
    private static final String MIX_SIMPLE_VERSIONABLE = "mix:simpleVersionable";
    private static final Logger log = LoggerFactory.getLogger(VersionablePropertiesEditor.class);
    private final NodeBuilder rootBuilder;
    private final NodeBuilder versionStorage;
    private final NodeBuilder builder;
    private final TypePredicate isVersionable;
    private final TypePredicate isNtVersion;
    private final TypePredicate isFrozenNode;

    private VersionablePropertiesEditor(NodeBuilder rootBuilder) {
        this.builder = rootBuilder;
        this.rootBuilder = rootBuilder;
        this.versionStorage = VersionHistoryUtil.getVersionStorage(rootBuilder);
        this.isVersionable = new TypePredicate(rootBuilder.getNodeState(), "mix:versionable");
        this.isNtVersion = new TypePredicate(rootBuilder.getNodeState(), "nt:version");
        this.isFrozenNode = new TypePredicate(rootBuilder.getNodeState(), "nt:frozenNode");
    }

    private VersionablePropertiesEditor(VersionablePropertiesEditor parent, NodeBuilder builder) {
        this.builder = builder;
        this.rootBuilder = parent.rootBuilder;
        this.versionStorage = parent.versionStorage;
        this.isVersionable = parent.isVersionable;
        this.isNtVersion = parent.isNtVersion;
        this.isFrozenNode = parent.isFrozenNode;
    }

    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        NodeBuilder nodeBuilder = this.builder.getChildNode(name);
        if (this.isVersionable.test(after)) {
            this.fixProperties(nodeBuilder);
        } else if (this.isFrozenNode.test(after)) {
            VersionablePropertiesEditor.updateFrozenMixins(nodeBuilder);
        }
        return new VersionablePropertiesEditor(this, nodeBuilder);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        return this.childNodeAdded(name, after);
    }

    private static boolean updateFrozenMixins(NodeBuilder builder) {
        HashSet mixins;
        if (builder.hasProperty("jcr:frozenMixinTypes") && (mixins = Sets.newHashSet((Iterable)((Iterable)builder.getProperty("jcr:frozenMixinTypes").getValue(Type.NAMES)))).remove(MIX_SIMPLE_VERSIONABLE)) {
            mixins.add("mix:versionable");
            builder.setProperty(MultiGenericPropertyState.nameProperty((String)"jcr:frozenMixinTypes", (Iterable)mixins));
            return true;
        }
        return false;
    }

    private void fixProperties(NodeBuilder node) {
        NodeState versionHistory = VersionHistoryUtil.getVersionHistoryNodeState(this.versionStorage.getNodeState(), node.getString("jcr:uuid"));
        if (!versionHistory.exists()) {
            log.warn("No version history for {}", (Object)node);
            return;
        }
        HashSet<String> updated = new HashSet<String>();
        if (!node.hasProperty("jcr:versionHistory")) {
            node.setProperty("jcr:versionHistory", (Object)versionHistory.getString("jcr:uuid"), Type.REFERENCE);
            updated.add("jcr:versionHistory");
        }
        String baseVersion = null;
        if (!node.hasProperty("jcr:baseVersion")) {
            baseVersion = this.getLastVersion(versionHistory);
            node.setProperty("jcr:baseVersion", (Object)baseVersion, Type.REFERENCE);
            updated.add("jcr:baseVersion");
        }
        if (!node.hasProperty("jcr:predecessors")) {
            baseVersion = baseVersion == null ? this.getLastVersion(versionHistory) : baseVersion;
            ArrayList<String> predecessors = new ArrayList<String>();
            if (node.getBoolean("jcr:isCheckedOut")) {
                predecessors.add(baseVersion);
            }
            node.setProperty("jcr:predecessors", predecessors, Type.REFERENCES);
            updated.add("jcr:predecessors");
        }
        if (!updated.isEmpty()) {
            log.info("Updated versionable properties {} for {}", updated, (Object)node);
        }
    }

    private String getLastVersion(NodeState versionHistory) {
        NodeState lastVersion = versionHistory.getChildNode("jcr:rootVersion");
        for (ChildNodeEntry child : versionHistory.getChildNodeEntries()) {
            NodeState v = child.getNodeState();
            if (!this.isNtVersion.test(v) || v.getProperty("jcr:successors").count() != 0) continue;
            lastVersion = v;
        }
        return lastVersion.getString("jcr:uuid");
    }

    public static class Provider
    implements EditorProvider {
        public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) throws CommitFailedException {
            return new VersionablePropertiesEditor(builder);
        }

        public String toString() {
            return "VersionablePropertiesEditor";
        }
    }
}

