/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.jackrabbit.oak.commons.jmx.AbstractCheckpointMBean;
import org.apache.jackrabbit.oak.plugins.document.Checkpoints;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentCheckpointMBean
extends AbstractCheckpointMBean {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final DocumentNodeStore store;

    public DocumentCheckpointMBean(DocumentNodeStore store) {
        this.store = store;
    }

    protected void collectCheckpoints(TabularDataSupport tab) throws OpenDataException {
        SortedMap<Revision, Checkpoints.Info> checkpoints = this.store.getCheckpoints().getCheckpoints();
        for (Map.Entry checkpoint : checkpoints.entrySet()) {
            String id = ((Revision)checkpoint.getKey()).toString();
            Checkpoints.Info info = (Checkpoints.Info)checkpoint.getValue();
            Date created = new Date(((Revision)checkpoint.getKey()).getTimestamp());
            Date expires = new Date(info.getExpiryTime());
            tab.put(id, this.toCompositeData(id, created.toString(), expires.toString(), info.get()));
        }
    }

    public long getOldestCheckpointCreationTimestamp() {
        SortedMap<Revision, Checkpoints.Info> checkpoints = this.store.getCheckpoints().getCheckpoints();
        long minTimestamp = Long.MAX_VALUE;
        for (Map.Entry checkpoint : checkpoints.entrySet()) {
            minTimestamp = Math.min(minTimestamp, ((Revision)checkpoint.getKey()).getTimestamp());
        }
        return minTimestamp == Long.MAX_VALUE ? 0L : minTimestamp;
    }

    public String createCheckpoint(long lifetime) {
        String cp = this.store.checkpoint(lifetime);
        this.log.info("Created checkpoint [{}] with lifetime {}", (Object)cp, (Object)lifetime);
        return cp;
    }

    public boolean releaseCheckpoint(String checkpoint) {
        this.log.info("Released checkpoint [{}]", (Object)checkpoint);
        return this.store.release(checkpoint);
    }
}

