/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.components.quickinfo.model;

import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.silverpeas.components.delegatednews.model.DelegatedNews;
import org.silverpeas.components.quickinfo.model.NewsModel;
import org.silverpeas.components.quickinfo.model.NewsPK;
import org.silverpeas.core.ResourceReference;
import org.silverpeas.core.WAPrimaryKey;
import org.silverpeas.core.comment.service.CommentService;
import org.silverpeas.core.comment.service.CommentServiceProvider;
import org.silverpeas.core.contribution.ContributionVisibility;
import org.silverpeas.core.contribution.attachment.AttachmentServiceProvider;
import org.silverpeas.core.contribution.attachment.model.DocumentType;
import org.silverpeas.core.contribution.attachment.util.SimpleDocumentList;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.ContributionModel;
import org.silverpeas.core.contribution.model.SilverpeasContent;
import org.silverpeas.core.contribution.model.Thumbnail;
import org.silverpeas.core.contribution.model.WithAttachment;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WithThumbnail;
import org.silverpeas.core.contribution.publication.model.PublicationDetail;
import org.silverpeas.core.contribution.publication.model.PublicationPK;
import org.silverpeas.core.contribution.publication.model.PublicationPath;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.io.media.image.thumbnail.control.ThumbnailController;
import org.silverpeas.core.io.media.image.thumbnail.model.ThumbnailDetail;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcException;
import org.silverpeas.core.pdc.pdc.service.PdcManager;
import org.silverpeas.core.persistence.datasource.model.identifier.UuidIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.SilverpeasJpaEntity;
import org.silverpeas.core.reminder.WithReminder;
import org.silverpeas.core.silverstatistics.access.service.StatisticService;
import org.silverpeas.core.util.DateUtil;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.kernel.util.StringUtil;

@Entity
@Table(name="sc_quickinfo_news")
@NamedQueries(value={@NamedQuery(name="newsFromComponentInstances", query="select n from News n where n.componentInstanceId in :componentInstanceIds order by n.publishDate DESC, n.lastUpdateDate DESC"), @NamedQuery(name="newsByForeignId", query="select n from News n where n.publicationId = :foreignId"), @NamedQuery(name="newsMandatories", query="select n from News n where n.mandatory = :mandatory"), @NamedQuery(name="newsForTicker", query="select n from News n where n.ticker = :ticker")})
public class News
extends SilverpeasJpaEntity<News, UuidIdentifier>
implements SilverpeasContent,
WithAttachment,
WithThumbnail,
WithReminder,
WithPermanentLink {
    public static final String CONTRIBUTION_TYPE = "News";
    private static final long serialVersionUID = 1L;
    @Transient
    private PublicationDetail publication;
    @Transient
    private String content;
    @Transient
    private DelegatedNews delegatedNews;
    @Column(name="instanceId", nullable=false)
    private String componentInstanceId;
    @Column(name="important", nullable=false)
    @NotNull
    private boolean important = false;
    @Column(name="broadcastTicker", nullable=false)
    @NotNull
    private boolean ticker = false;
    @Column(name="broadcastMandatory", nullable=false)
    @NotNull
    private boolean mandatory = false;
    @Column(name="foreignId", nullable=false)
    @Size(min=1)
    private @Size(min=1) String publicationId;
    @Column
    private Date publishDate;
    @Column
    private String publishedBy;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(News news) {
        return News.builder().setTitleAndDescription(news.getTitle(), news.getDescription()).setKeywords(news.getKeywords()).setVisibilityPeriod(news.getVisibility().getPeriod()).setImportant(news.isImportant()).setTicker(news.isTicker()).setMandatory(news.isMandatory());
    }

    protected News() {
    }

    public NewsPK getPK() {
        return new NewsPK(this.getId(), this.getComponentInstanceId());
    }

    public News(PublicationDetail publication) {
        this.setPublication(publication);
    }

    public PublicationDetail getPublication() {
        return this.publication;
    }

    public News setId(String id) {
        return (News)super.setId(id);
    }

    public String getTitle() {
        return this.getPublication().getName();
    }

    public void setTitle(String title) {
        this.getPublication().setName(title);
    }

    public String getDescription() {
        return this.getPublication().getDescription();
    }

    public void setKeywords(String keywords) {
        this.getPublication().setKeywords(keywords);
    }

    public String getKeywords() {
        return this.getPublication().getKeywords();
    }

    public void setDescription(String desc) {
        this.getPublication().setDescription(desc);
    }

    public void setCreatorId(String userId) {
        super.createdBy(userId);
        this.getPublication().setCreatorId(userId);
    }

    public void setUpdaterId(String userId) {
        super.lastUpdatedBy(userId);
        this.getPublication().setUpdaterId(userId);
    }

    public String getUpdaterId() {
        return this.getPublication().getUpdaterId();
    }

    public Date getUpdateDate() {
        return this.getPublication().getLastUpdateDate();
    }

    public boolean isVisible() {
        return this.getVisibility().isActive();
    }

    public boolean isNoMoreVisible() {
        return this.getVisibility().hasBeenActive();
    }

    public boolean isNotYetVisible() {
        return this.getVisibility().willBeActive();
    }

    public void setVisibilityPeriod(Period period) {
        this.getPublication().setVisibilityPeriod(period);
    }

    public ContributionVisibility getVisibility() {
        return this.publication.getVisibility();
    }

    public void setContentToStore(String content) {
        this.content = content;
    }

    public String getContentToStore() {
        return this.content;
    }

    public String getContent() {
        return this.getPublication().getContent().getRenderer().renderView();
    }

    public List<Integer> getBroadcastModes() {
        ArrayList<Integer> modes = new ArrayList<Integer>();
        modes.add(this.getPublication().getImportance());
        return modes;
    }

    public Thumbnail getThumbnail() {
        ThumbnailDetail thumbnail = new ThumbnailDetail(this.getComponentInstanceId(), Integer.parseInt(this.getPublicationId()), 1);
        return ThumbnailController.getCompleteThumbnail((ThumbnailDetail)thumbnail);
    }

    public int getNumberOfComments() {
        CommentService commentService = CommentServiceProvider.getCommentService();
        return commentService.getCommentsCountOnResource(CONTRIBUTION_TYPE, new ResourceReference((WAPrimaryKey)this.getPK()));
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public void setComponentInstanceId(String componentId) {
        this.getPublication().getPK().setComponentName(componentId);
        this.componentInstanceId = componentId;
    }

    public String getSilverpeasContentId() {
        return this.getPublication().getSilverObjectId();
    }

    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from((String)this.getComponentInstanceId(), (String)this.getId(), (String)this.getContributionType());
    }

    public String getContributionType() {
        return CONTRIBUTION_TYPE;
    }

    public boolean isIndexable() {
        return false;
    }

    public static String getResourceType() {
        return CONTRIBUTION_TYPE;
    }

    public Optional<PublicationPath> getResourcePath() {
        return this.getPublication().getResourcePath();
    }

    public void setImportant(boolean important) {
        this.important = important;
    }

    public boolean isImportant() {
        return this.important;
    }

    public void setTicker(boolean ticker) {
        this.ticker = ticker;
    }

    public boolean isTicker() {
        return this.ticker;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setPublicationId(String publicationId) {
        this.publicationId = publicationId;
    }

    public String getPublicationId() {
        return this.publicationId;
    }

    public int getNbAccess() {
        return this.getStatisticService().getCount((SilverpeasContent)this);
    }

    public boolean isDraft() {
        return this.getPublication().isDraft();
    }

    public void setDraft() {
        this.getPublication().setStatus("Draft");
    }

    public void setPublished() {
        this.getPublication().setStatus("Valid");
    }

    public List<ClassifyPosition> getTaxonomyPositions() throws PdcException {
        String silverObjectId = this.getPublication().getSilverObjectId();
        if (StringUtil.isDefined((String)silverObjectId)) {
            return this.getTaxonomyService().getPositions(Integer.parseInt(silverObjectId), this.getComponentInstanceId());
        }
        return Collections.emptyList();
    }

    public String getPermalink() {
        return URLUtil.getSimpleURL((int)2, (String)this.getPublicationId());
    }

    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }

    public Date getPublishDate() {
        return this.publishDate;
    }

    public void setPublishedBy(String publishedBy) {
        this.publishedBy = publishedBy;
    }

    public String getPublishedBy() {
        return this.publishedBy;
    }

    public boolean isUpdatedAfterBePublished() {
        if (this.getPublishDate() == null) {
            return false;
        }
        return DateUtil.compareTo((Date)this.getUpdateDate(), (Date)this.getPublishDate(), (boolean)false) > 0;
    }

    public DelegatedNews getDelegatedNews() {
        return this.delegatedNews;
    }

    public void setDelegatedNews(DelegatedNews dn) {
        this.delegatedNews = dn;
    }

    public boolean isCanBeSubmittedOnHomepage() {
        return this.delegatedNews == null || this.delegatedNews.isDenied();
    }

    public Date getOnlineDate() {
        Date visibilityStart;
        if (this.getPublishDate() != null && (visibilityStart = TemporalConverter.asDate((Temporal)TemporalConverter.asOffsetDateTime((Temporal)this.getPublication().getVisibility().getPeriod().getStartDate()).atZoneSameInstant(ZoneId.systemDefault()))).after(this.getPublishDate())) {
            return visibilityStart;
        }
        return this.getPublishDate();
    }

    public int getNumberOfAttachments() {
        SimpleDocumentList attachments = AttachmentServiceProvider.getAttachmentService().listDocumentsByForeignKeyAndType(this.getForeignPK().toResourceReference(), DocumentType.attachment, I18NHelper.DEFAULT_LANGUAGE);
        return attachments.size();
    }

    protected void setPublication(PublicationDetail publication) {
        this.publication = publication;
    }

    protected PublicationPK getForeignPK() {
        return new PublicationPK(this.getPublicationId(), this.getComponentInstanceId());
    }

    private StatisticService getStatisticService() {
        return StatisticService.get();
    }

    private PdcManager getTaxonomyService() {
        return PdcManager.get();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public ContributionModel getModel() {
        return new NewsModel(this);
    }

    public static class Builder {
        private final News news = new News();

        public Builder() {
            this.news.publication = PublicationDetail.builder().build();
        }

        public News build() {
            return this.news;
        }

        public Builder setMandatory(boolean mandatory) {
            this.news.setMandatory(mandatory);
            return this;
        }

        public Builder setTicker(boolean ticker) {
            this.news.setTicker(ticker);
            return this;
        }

        public Builder setImportant(boolean important) {
            this.news.setImportant(important);
            return this;
        }

        public Builder setVisibilityPeriod(Period period) {
            this.news.setVisibilityPeriod(period);
            return this;
        }

        public Builder setKeywords(String keywords) {
            this.news.setKeywords(keywords);
            return this;
        }

        public Builder setTitleAndDescription(String title, String description) {
            this.news.setTitle(title);
            this.news.setDescription(description);
            return this;
        }
    }
}

