/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.mongodb.event.ServerHeartbeatFailedEvent;
import com.mongodb.event.ServerHeartbeatStartedEvent;
import com.mongodb.event.ServerHeartbeatSucceededEvent;
import com.mongodb.event.ServerMonitorListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class CompositeServerMonitorListener
implements ServerMonitorListener {
    private final List<ServerMonitorListener> listeners = new CopyOnWriteArrayList<ServerMonitorListener>();

    CompositeServerMonitorListener() {
    }

    void addListener(ServerMonitorListener listener) {
        this.listeners.add(listener);
    }

    void removeListener(ServerMonitorListener listener) {
        this.listeners.remove(listener);
    }

    public void serverHearbeatStarted(ServerHeartbeatStartedEvent event) {
        this.listeners.forEach(l -> l.serverHearbeatStarted(event));
    }

    public void serverHeartbeatSucceeded(ServerHeartbeatSucceededEvent event) {
        this.listeners.forEach(l -> l.serverHeartbeatSucceeded(event));
    }

    public void serverHeartbeatFailed(ServerHeartbeatFailedEvent event) {
        this.listeners.forEach(l -> l.serverHeartbeatFailed(event));
    }
}

