/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.RecordType;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNotFoundException;
import org.apache.jackrabbit.oak.segment.SegmentVersion;
import org.apache.jackrabbit.oak.segment.file.AbstractFileStore;
import org.apache.jackrabbit.oak.segment.file.JournalEntry;
import org.apache.jackrabbit.oak.segment.file.JournalReader;
import org.apache.jackrabbit.oak.segment.file.proc.Proc;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitorAdapter;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.spi.state.NodeState;

class FileStoreProcBackend
implements Proc.Backend {
    private final AbstractFileStore fileStore;
    private final SegmentNodeStorePersistence persistence;
    private final SegmentArchiveManager archiveManager;

    FileStoreProcBackend(AbstractFileStore fileStore, SegmentNodeStorePersistence persistence) throws IOException {
        this.fileStore = fileStore;
        this.persistence = persistence;
        this.archiveManager = persistence.createArchiveManager(true, false, new IOMonitorAdapter(), new FileStoreMonitorAdapter(), new RemoteStoreMonitorAdapter());
    }

    @Override
    public boolean tarExists(String name) {
        try {
            return this.archiveManager.listArchives().contains(name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Optional<Long> getTarSize(String name) {
        Optional<Long> optional;
        block8: {
            SegmentArchiveReader reader = this.archiveManager.open(name);
            try {
                optional = Optional.ofNullable(reader).map(SegmentArchiveReader::length);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
        }
        return optional;
    }

    @Override
    public Iterable<String> getTarNames() {
        try {
            return this.archiveManager.listArchives();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean segmentExists(String name, String segmentId) {
        try (SegmentArchiveReader reader = this.archiveManager.open(name);){
            if (reader == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = this.segmentExists(reader, UUID.fromString(segmentId));
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean segmentExists(SegmentArchiveReader reader, UUID id) {
        return reader.containsSegment(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getSegmentIds(String name) {
        try (SegmentArchiveReader reader = this.archiveManager.open(name);){
            if (reader == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Iterable<String> iterable = this.getSegmentIds(reader);
            return iterable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Iterable<String> getSegmentIds(SegmentArchiveReader reader) {
        ArrayList<String> ids = new ArrayList<String>();
        for (SegmentArchiveEntry entry : reader.listSegments()) {
            ids.add(new UUID(entry.getMsb(), entry.getLsb()).toString());
        }
        return ids;
    }

    private Optional<Segment> readSegment(String id) {
        return this.readSegment(UUID.fromString(id));
    }

    private Optional<Segment> readSegment(UUID id) {
        return this.readSegment(this.fileStore.getSegmentIdProvider().newSegmentId(id.getMostSignificantBits(), id.getLeastSignificantBits()));
    }

    private Optional<Segment> readSegment(SegmentId id) {
        try {
            return Optional.of(this.fileStore.readSegment(id));
        }
        catch (SegmentNotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Proc.Backend.Segment> getSegment(String id) {
        return this.readSegment(id).map(segment -> new Proc.Backend.Segment((Segment)segment){
            final /* synthetic */ Segment val$segment;
            {
                this.val$segment = segment;
            }

            @Override
            public int getGeneration() {
                return this.val$segment.getGcGeneration().getGeneration();
            }

            @Override
            public int getFullGeneration() {
                return this.val$segment.getGcGeneration().getFullGeneration();
            }

            @Override
            public boolean isCompacted() {
                return this.val$segment.getGcGeneration().isCompacted();
            }

            @Override
            public int getLength() {
                return this.val$segment.size();
            }

            @Override
            public int getVersion() {
                return SegmentVersion.asByte(this.val$segment.getSegmentVersion());
            }

            @Override
            public boolean isDataSegment() {
                return this.val$segment.getSegmentId().isDataSegmentId();
            }

            @Override
            public Optional<String> getInfo() {
                return Optional.ofNullable(this.val$segment.getSegmentInfo());
            }
        });
    }

    @Override
    public Optional<InputStream> getSegmentData(String segmentId) {
        return this.readSegment(segmentId).map(segment -> {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                segment.writeTo(out);
            }
            catch (IOException e) {
                return null;
            }
            return new ByteArrayInputStream(out.toByteArray());
        });
    }

    @Override
    public Optional<Iterable<String>> getSegmentReferences(String segmentId) {
        return this.readSegment(segmentId).map(segment -> {
            ArrayList<String> references = new ArrayList<String>(segment.getReferencedSegmentIdCount());
            for (int i = 0; i < segment.getReferencedSegmentIdCount(); ++i) {
                references.add(segment.getReferencedSegmentId(i).toString());
            }
            return references;
        });
    }

    @Override
    public Optional<Iterable<Proc.Backend.Record>> getSegmentRecords(final String segmentId) {
        return this.readSegment(segmentId).map(segment -> {
            ArrayList records = new ArrayList();
            segment.forEachRecord((number, type, offset) -> records.add(new Proc.Backend.Record((Segment)segment, type){
                final /* synthetic */ Segment val$segment;
                final /* synthetic */ RecordType val$type;
                {
                    this.val$segment = segment;
                    this.val$type = recordType;
                }

                @Override
                public int getNumber() {
                    return number;
                }

                @Override
                public String getSegmentId() {
                    return segmentId;
                }

                @Override
                public int getOffset() {
                    return offset;
                }

                @Override
                public int getAddress() {
                    return this.val$segment.getAddress(offset);
                }

                @Override
                public String getType() {
                    return this.val$type.name();
                }

                @Override
                public Optional<NodeState> getRoot() {
                    if (RecordType.NODE == this.val$type) {
                        RecordId id = new RecordId(this.val$segment.getSegmentId(), number);
                        return Optional.of(FileStoreProcBackend.this.fileStore.getReader().readNode(id));
                    }
                    return Optional.empty();
                }
            }));
            return records;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean commitExists(String handle) {
        long timestamp = Long.parseLong(handle);
        try (JournalReader reader = new JournalReader(this.persistence.getJournalFile());){
            JournalEntry entry;
            Iterator iterator = this.iterable((Iterator)((Object)reader)).iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while ((entry = (JournalEntry)iterator.next()).getTimestamp() != timestamp);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T> Iterable<T> iterable(Iterator<T> i) {
        return () -> i;
    }

    @Override
    public Iterable<String> getCommitHandles() {
        ArrayList<String> arrayList;
        JournalReader reader = new JournalReader(this.persistence.getJournalFile());
        try {
            ArrayList<String> handles = new ArrayList<String>();
            for (JournalEntry entry : this.iterable((Iterator)((Object)reader))) {
                handles.add(Long.toString(entry.getTimestamp()));
            }
            arrayList = handles;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return arrayList;
    }

    @Override
    public Optional<Proc.Backend.Commit> getCommit(String handle) {
        JournalEntry entry;
        try (JournalReader reader = new JournalReader(this.persistence.getJournalFile());){
            entry = this.getEntry(reader, Long.parseLong(handle));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (entry == null) {
            return Optional.empty();
        }
        return Optional.of(new Proc.Backend.Commit(){

            @Override
            public long getTimestamp() {
                return entry.getTimestamp();
            }

            @Override
            public String getRevision() {
                return entry.getRevision();
            }

            @Override
            public Optional<NodeState> getRoot() {
                RecordId id = RecordId.fromString(FileStoreProcBackend.this.fileStore.getSegmentIdProvider(), entry.getRevision());
                return Optional.of(FileStoreProcBackend.this.fileStore.getReader().readNode(id));
            }
        });
    }

    private JournalEntry getEntry(JournalReader reader, long timestamp) {
        for (JournalEntry entry : this.iterable((Iterator)((Object)reader))) {
            if (entry.getTimestamp() != timestamp) continue;
            return entry;
        }
        return null;
    }
}

