/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryValidator {
    private static final Logger LOG = LoggerFactory.getLogger(QueryValidator.class);
    public static final String QUERY_VALIDATOR = "queryValidator";
    private static final int NEXT_LOG_MILLIS = 10000;
    private final ConcurrentSkipListMap<String, ProblematicQueryPattern> map = new ConcurrentSkipListMap();

    public void setPattern(String key, String pattern, String comment, boolean failQuery) {
        LOG.debug("set pattern key={} pattern={} comment={} failQuery={}", new Object[]{key, pattern, comment, failQuery});
        if (pattern.isEmpty()) {
            this.map.remove(key);
        } else {
            ProblematicQueryPattern p = new ProblematicQueryPattern(key, pattern, comment, failQuery);
            this.map.put(key, p);
        }
    }

    public String getJson() {
        JsopBuilder b = new JsopBuilder().array();
        for (ProblematicQueryPattern p : this.map.values()) {
            b.newline().encodedValue(p.getJson());
        }
        return b.endArray().toString();
    }

    public void checkStatement(String statement) throws ParseException {
        if (this.map.isEmpty()) {
            return;
        }
        for (ProblematicQueryPattern p : this.map.values()) {
            p.checkStatement(statement);
        }
    }

    public void init(NodeStore store) {
        NodeState def = store.getRoot().getChildNode("oak:index").getChildNode(QUERY_VALIDATOR);
        if (!def.exists()) {
            return;
        }
        for (ChildNodeEntry e : def.getChildNodeEntries()) {
            String pattern;
            String key = e.getName();
            NodeState n = e.getNodeState();
            PropertyState p = n.getProperty("pattern");
            if (p == null) continue;
            if (p.isArray()) {
                int len = p.count();
                StringBuilder buff = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    if (buff.length() > 0) {
                        buff.append(".*");
                    }
                    buff.append(Pattern.quote((String)p.getValue(Type.STRING, i)));
                }
                pattern = buff.toString();
            } else {
                pattern = (String)p.getValue(Type.STRING);
            }
            String comment = (String)n.getProperty("comment").getValue(Type.STRING);
            boolean failQuery = (Boolean)n.getProperty("failQuery").getValue(Type.BOOLEAN);
            if (pattern == null || comment == null) continue;
            this.setPattern(key, pattern, comment, failQuery);
        }
    }

    private static class ProblematicQueryPattern {
        private final String key;
        private final String pattern;
        private final String comment;
        private final Pattern compiledPattern;
        private final boolean failQuery;
        private long executedLast;
        private long executedCount;

        ProblematicQueryPattern(String key, String pattern, String comment, boolean failQuery) {
            this.key = key;
            this.pattern = pattern;
            this.comment = comment;
            this.compiledPattern = Pattern.compile(pattern);
            this.failQuery = failQuery;
        }

        void checkStatement(String statement) throws ParseException {
            long now;
            if (!this.compiledPattern.matcher(statement).matches()) {
                return;
            }
            ++this.executedCount;
            long previousExecuted = this.executedLast;
            this.executedLast = now = System.currentTimeMillis();
            if (this.failQuery) {
                String message = "Query is blacklisted: statement=" + statement + " pattern=" + this.pattern;
                ParseException p = new ParseException(message, 0);
                LOG.warn(message, (Throwable)p);
                throw p;
            }
            String message = "Query is questionable, but executed: statement=" + statement + " pattern=" + this.pattern;
            if (previousExecuted + 10000L < now) {
                LOG.warn(message, (Throwable)new Exception("QueryValidator"));
            } else {
                LOG.debug(message, (Throwable)new Exception("QueryValidator"));
            }
        }

        String getJson() {
            return new JsopBuilder().object().newline().key("key").value(this.key).newline().key("pattern").value(this.pattern).newline().key("comment").value(this.comment).newline().key("failQuery").value(this.failQuery).newline().key("executedLast").value(this.executedLast == 0L ? "" : new Timestamp(this.executedLast).toString()).newline().key("executedCount").value(this.executedCount).newline().endObject().toString();
        }
    }
}

