/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.logging;

import java.io.Serializable;
import java.security.Permission;
import java.util.Arrays;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.as.naming.logging.NamingLogger;
import org.jboss.as.naming.subsystem.BindingType;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceName;

public class NamingLogger_$logger
extends DelegatingBasicLogger
implements NamingLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = NamingLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public NamingLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void activatingSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.activatingSubsystem$str(), new Object[0]);
    }

    protected String activatingSubsystem$str() {
        return "WFLYNAM0001: Activating Naming Subsystem";
    }

    @Override
    public final void failedToSet(Throwable cause, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToSet$str(), (Object)name);
    }

    protected String failedToSet$str() {
        return "WFLYNAM0002: Failed to set %s";
    }

    @Override
    public final void startingService() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.startingService$str(), new Object[0]);
    }

    protected String startingService$str() {
        return "WFLYNAM0003: Starting Naming Service";
    }

    @Override
    public final void failedToReleaseBinderService(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToReleaseBinderService$str(), new Object[0]);
    }

    protected String failedToReleaseBinderService$str() {
        return "WFLYNAM0012: Failed to release binder service, used for a runtime made JNDI binding";
    }

    @Override
    public final void failedToLookupJndiViewValue(String entry, Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.failedToLookupJndiViewValue$str(), (Object)entry);
    }

    protected String failedToLookupJndiViewValue$str() {
        return "WFLYNAM0013: Failed to obtain jndi view value for entry %s.";
    }

    protected String cannotAddToReadOnlyPermissionCollection$str() {
        return "WFLYNAM0014: Attempt to add a Permission to a readonly PermissionCollection";
    }

    @Override
    public final SecurityException cannotAddToReadOnlyPermissionCollection() {
        SecurityException result = new SecurityException(String.format(this.getLoggingLocale(), this.cannotAddToReadOnlyPermissionCollection$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String cannotBeNull$str() {
        return "WFLYNAM0015: %s cannot be null.";
    }

    @Override
    public final String cannotBeNull(String name) {
        return String.format(this.getLoggingLocale(), this.cannotBeNull$str(), name);
    }

    protected String cannotDeferenceObject$str() {
        return "WFLYNAM0016: Could not dereference object";
    }

    @Override
    public final NamingException cannotDeferenceObject(Throwable cause) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotDeferenceObject$str(), new Object[0]));
        result.initCause(cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotListNonContextBinding$str() {
        return "WFLYNAM0017: Unable to list a non Context binding.";
    }

    @Override
    public final NamingException cannotListNonContextBinding() {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotListNonContextBinding$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotLookupLink$str() {
        return "WFLYNAM0018: Could not lookup link";
    }

    @Override
    public final String cannotLookupLink() {
        return String.format(this.getLoggingLocale(), this.cannotLookupLink$str(), new Object[0]);
    }

    protected String cannotResolveService1$str() {
        return "WFLYNAM0020: Could not resolve service %s";
    }

    @Override
    public final NamingException cannotResolveService(ServiceName serviceName) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotResolveService1$str(), serviceName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResolveService3$str() {
        return "WFLYNAM0021: Could not resolve service reference to %s in factory %s. Service was in state %s.";
    }

    @Override
    public final NamingException cannotResolveService(ServiceName serviceName, String className, String state) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotResolveService3$str(), serviceName, className, state));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotResolveServiceBug$str() {
        return "WFLYNAM0022: Could not resolve service reference to %s in factory %s. This is a bug in ServiceReferenceObjectFactory. State was %s.";
    }

    @Override
    public final NamingException cannotResolveServiceBug(ServiceName serviceName, String className, String state) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.cannotResolveServiceBug$str(), serviceName, className, state));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateBinding$str() {
        return "WFLYNAM0023: Duplicate JNDI bindings for '%s' are not compatible.  [%s] != [%s]";
    }

    @Override
    public final String duplicateBinding(JndiName jndiName, Object existing, Object value) {
        return String.format(this.getLoggingLocale(), this.duplicateBinding$str(), jndiName, existing, value);
    }

    protected String emptyNameNotAllowed$str() {
        return "WFLYNAM0024: An empty name is not allowed";
    }

    @Override
    public final InvalidNameException emptyNameNotAllowed() {
        InvalidNameException result = new InvalidNameException(String.format(this.getLoggingLocale(), this.emptyNameNotAllowed$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String entryNotRegistered$str() {
        return "WFLYNAM0025: Jndi entry '%s' is not yet registered in context '%s'";
    }

    @Override
    public final IllegalStateException entryNotRegistered(Throwable cause, String contextName, Context context) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.entryNotRegistered$str(), contextName, context), cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToDestroyRootContext$str() {
        return "WFLYNAM0026: Failed to destroy root context";
    }

    @Override
    public final IllegalStateException failedToDestroyRootContext(Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.failedToDestroyRootContext$str(), new Object[0]), cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToInstantiate$str() {
        return "WFLYNAM0027: Failed instantiate %s %s from classloader %s";
    }

    @Override
    public final NamingException failedToInstantiate(Throwable cause, String description, String className, ClassLoader classLoader) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.failedToInstantiate$str(), description, className, classLoader));
        result.initCause(cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String failedToReadContextEntries$str() {
        return "WFLYNAM0028: Failed to read %s context entries.";
    }

    @Override
    public final String failedToReadContextEntries(String bindingName) {
        return String.format(this.getLoggingLocale(), this.failedToReadContextEntries$str(), bindingName);
    }

    protected String failedToStart$str() {
        return "WFLYNAM0029: Failed to start %s";
    }

    @Override
    public final String failedToStart(String name) {
        return String.format(this.getLoggingLocale(), this.failedToStart$str(), name);
    }

    protected String illegalContextInName$str() {
        return "WFLYNAM0030: Illegal context in name: %s";
    }

    @Override
    public final RuntimeException illegalContextInName(String jndiName) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.illegalContextInName$str(), jndiName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidContextReference$str() {
        return "WFLYNAM0032: Invalid context reference.  Not a '%s' reference.";
    }

    @Override
    public final NamingException invalidContextReference(String referenceName) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.invalidContextReference$str(), referenceName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidJndiName$str() {
        return "WFLYNAM0033: A valid JNDI name must be provided: %s";
    }

    @Override
    public final IllegalArgumentException invalidJndiName(String jndiName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidJndiName$str(), jndiName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidLoadFactor$str() {
        return "WFLYNAM0034: Load factor must be greater than 0 and less than or equal to 1";
    }

    @Override
    public final IllegalArgumentException invalidLoadFactor() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidLoadFactor$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPermission$str() {
        return "WFLYNAM0035: invalid permission, unknown action: %s";
    }

    @Override
    public final IllegalArgumentException invalidPermission(Permission permission) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPermission$str(), permission));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPermissionAction$str() {
        return "WFLYNAM0036: invalid permission, unknown action: %s";
    }

    @Override
    public final IllegalArgumentException invalidPermissionAction(String permissionAction) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPermissionAction$str(), permissionAction));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTableSize$str() {
        return "WFLYNAM0037: Can not have a negative size table!";
    }

    @Override
    public final IllegalArgumentException invalidTableSize() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidTableSize$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String jndiViewNotAvailable$str() {
        return "WFLYNAM0038: Jndi view is only available in runtime mode.";
    }

    @Override
    public final String jndiViewNotAvailable() {
        return String.format(this.getLoggingLocale(), this.jndiViewNotAvailable$str(), new Object[0]);
    }

    protected String nameNotFoundInContext$str() {
        return "WFLYNAM0039: Name '%s' not found in context '%s'";
    }

    @Override
    public final NameNotFoundException nameNotFoundInContext(String name, Name contextName) {
        NameNotFoundException result = new NameNotFoundException(String.format(this.getLoggingLocale(), this.nameNotFoundInContext$str(), name, contextName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nullVar$str() {
        return "WFLYNAM0041: %s is null";
    }

    @Override
    public final IllegalArgumentException nullVar(String varName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nullVar$str(), varName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String objectFactoryCreationFailure$str() {
        return "WFLYNAM0042: Failed to create object factory from classloader.";
    }

    @Override
    public final NamingException objectFactoryCreationFailure(Throwable cause) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.objectFactoryCreationFailure$str(), new Object[0]));
        result.initCause(cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String readOnlyNamingContext$str() {
        return "WFLYNAM0043: Naming context is read-only";
    }

    @Override
    public final OperationNotSupportedException readOnlyNamingContext() {
        OperationNotSupportedException result = new OperationNotSupportedException(String.format(this.getLoggingLocale(), this.readOnlyNamingContext$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceAlreadyBound$str() {
        return "WFLYNAM0044: Service with name [%s] already bound.";
    }

    @Override
    public final IllegalArgumentException serviceAlreadyBound(ServiceName serviceName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.serviceAlreadyBound$str(), serviceName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String tableIsFull$str() {
        return "WFLYNAM0045: Table is full!";
    }

    @Override
    public final IllegalStateException tableIsFull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.tableIsFull$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String threadInterrupt$str() {
        return "WFLYNAM0046: Thread interrupted while retrieving service reference for service %s";
    }

    @Override
    public final NamingException threadInterrupt(ServiceName serviceName) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.threadInterrupt$str(), serviceName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidNameForContextBinding$str() {
        return "WFLYNAM0047: Invalid name for context binding %s";
    }

    @Override
    public final DeploymentUnitProcessingException invalidNameForContextBinding(String name) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.invalidNameForContextBinding$str(), name));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidNamespaceForBinding$str() {
        return "WFLYNAM0048: Invalid binding name %s, name must start with one of %s";
    }

    @Override
    public final OperationFailedException invalidNamespaceForBinding(String name, String namespaces) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.invalidNamespaceForBinding$str(), name, namespaces));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unknownBindingType$str() {
        return "WFLYNAM0049: Unknown binding type %s";
    }

    @Override
    public final OperationFailedException unknownBindingType(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unknownBindingType$str(), type));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unsupportedSimpleBindingType$str() {
        return "WFLYNAM0050: Unsupported simple binding type %s";
    }

    @Override
    public final OperationFailedException unsupportedSimpleBindingType(String type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unsupportedSimpleBindingType$str(), type));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToTransformURLBindingValue$str() {
        return "WFLYNAM0051: Unable to transform URL binding value %s";
    }

    @Override
    public final OperationFailedException unableToTransformURLBindingValue(String value, Throwable cause) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.unableToTransformURLBindingValue$str(), value), cause);
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotLoadModule$str() {
        return "WFLYNAM0052: Could not load module %s";
    }

    @Override
    public final OperationFailedException couldNotLoadModule(ModuleIdentifier moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotLoadModule$str(), moduleID));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotLoadClassFromModule$str() {
        return "WFLYNAM0053: Could not load class %s from module %s";
    }

    @Override
    public final OperationFailedException couldNotLoadClassFromModule(String className, ModuleIdentifier moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotLoadClassFromModule$str(), className, moduleID));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotInstantiateClassInstanceFromModule$str() {
        return "WFLYNAM0054: Could not instantiate instance of class %s from module %s";
    }

    @Override
    public final OperationFailedException couldNotInstantiateClassInstanceFromModule(String className, ModuleIdentifier moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.couldNotInstantiateClassInstanceFromModule$str(), className, moduleID));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String notAnInstanceOfObjectFactory$str() {
        return "WFLYNAM0055: Class %s from module %s is not an instance of ObjectFactory";
    }

    @Override
    public final OperationFailedException notAnInstanceOfObjectFactory(String className, ModuleIdentifier moduleID) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.notAnInstanceOfObjectFactory$str(), className, moduleID));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String resourceLookupForInjectionFailed$str() {
        return "WFLYNAM0059: Resource lookup for injection failed: %s";
    }

    @Override
    public final RuntimeException resourceLookupForInjectionFailed(String jndiName, Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.resourceLookupForInjectionFailed$str(), jndiName), cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String bindingTypeRequiresAttributeDefined$str() {
        return "WFLYNAM0060: Binding type %s requires attribute named %s defined";
    }

    @Override
    public final OperationFailedException bindingTypeRequiresAttributeDefined(BindingType bindingType, String attributeName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.bindingTypeRequiresAttributeDefined$str(), new Object[]{bindingType, attributeName}));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cacheNotValidForBindingType$str() {
        return "WFLYNAM0061: Binding type %s can not take a 'cache' attribute";
    }

    @Override
    public final OperationFailedException cacheNotValidForBindingType(BindingType type) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cacheNotValidForBindingType$str(), new Object[]{type}));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String lookupError$str() {
        return "WFLYNAM0062: Failed to lookup %s";
    }

    @Override
    public final NamingException lookupError(Throwable cause, String name) {
        NamingException result = new NamingException(String.format(this.getLoggingLocale(), this.lookupError$str(), name));
        result.initCause(cause);
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String serviceNotStarted$str() {
        return "WFLYNAM0063: %s service not started";
    }

    @Override
    public final IllegalStateException serviceNotStarted(ServiceName serviceName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotStarted$str(), serviceName));
        NamingLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotRebindExternalContext$str() {
        return "WFLYNAM0064: Cannot rebind external context lookup";
    }

    @Override
    public final OperationFailedException cannotRebindExternalContext() {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotRebindExternalContext$str(), new Object[0]));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String moduleNotFound$str() {
        return "WFLYNAM0065: Could not load module %s - the module or one of its dependencies is missing [%s]";
    }

    @Override
    public final OperationFailedException moduleNotFound(ModuleIdentifier moduleID, String missingModule) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.moduleNotFound$str(), moduleID, missingModule));
        NamingLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

