/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.configuration.cache.XSiteStateTransferConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class BackupConfiguration
extends ConfigurationElement<BackupConfiguration> {
    public static final AttributeDefinition<String> SITE = AttributeDefinition.builder((Enum)Attribute.SITE, null, String.class).autoPersist(false).immutable().build();
    public static final AttributeDefinition<BackupStrategy> STRATEGY = AttributeDefinition.builder((Enum)Attribute.STRATEGY, (Object)((Object)BackupStrategy.ASYNC)).immutable().build();
    public static final AttributeDefinition<Long> REPLICATION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.TIMEOUT, (Object)15000L).build();
    public static final AttributeDefinition<BackupFailurePolicy> FAILURE_POLICY = AttributeDefinition.builder((Enum)Attribute.BACKUP_FAILURE_POLICY, (Object)((Object)BackupFailurePolicy.WARN)).build();
    public static final AttributeDefinition<String> FAILURE_POLICY_CLASS = AttributeDefinition.builder((Enum)Attribute.FAILURE_POLICY_CLASS, null, String.class).immutable().build();
    public static final AttributeDefinition<Boolean> USE_TWO_PHASE_COMMIT = AttributeDefinition.builder((Enum)Attribute.USE_TWO_PHASE_COMMIT, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)true).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<String> site;
    private final org.infinispan.commons.configuration.attributes.Attribute<BackupStrategy> strategy;
    private final org.infinispan.commons.configuration.attributes.Attribute<Long> replicationTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<BackupFailurePolicy> backupFailurePolicy;
    private final org.infinispan.commons.configuration.attributes.Attribute<String> failurePolicyClass;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> useTwoPhaseCommit;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> enabled;
    private final AttributeSet attributes;
    private final TakeOfflineConfiguration takeOfflineConfiguration;
    private final XSiteStateTransferConfiguration xSiteStateTransferConfiguration;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(BackupConfiguration.class, new AttributeDefinition[]{SITE, STRATEGY, REPLICATION_TIMEOUT, FAILURE_POLICY, FAILURE_POLICY_CLASS, USE_TWO_PHASE_COMMIT, ENABLED});
    }

    public BackupConfiguration(AttributeSet attributes, TakeOfflineConfiguration takeOfflineConfiguration, XSiteStateTransferConfiguration xSiteStateTransferConfiguration) {
        super((Enum)Element.BACKUP, attributes, new ConfigurationElement[]{takeOfflineConfiguration, xSiteStateTransferConfiguration});
        this.attributes = attributes.checkProtection();
        this.takeOfflineConfiguration = takeOfflineConfiguration;
        this.xSiteStateTransferConfiguration = xSiteStateTransferConfiguration;
        this.site = attributes.attribute(SITE);
        this.strategy = attributes.attribute(STRATEGY);
        this.replicationTimeout = attributes.attribute(REPLICATION_TIMEOUT);
        this.backupFailurePolicy = attributes.attribute(FAILURE_POLICY);
        this.failurePolicyClass = attributes.attribute(FAILURE_POLICY_CLASS);
        this.useTwoPhaseCommit = attributes.attribute(USE_TWO_PHASE_COMMIT);
        this.enabled = attributes.attribute(ENABLED);
    }

    public String site() {
        return (String)this.site.get();
    }

    public BackupStrategy strategy() {
        return (BackupStrategy)((Object)this.strategy.get());
    }

    public TakeOfflineConfiguration takeOffline() {
        return this.takeOfflineConfiguration;
    }

    public String failurePolicyClass() {
        return (String)this.failurePolicyClass.get();
    }

    public boolean isAsyncBackup() {
        return this.strategy() == BackupStrategy.ASYNC;
    }

    public boolean isSyncBackup() {
        return this.strategy() == BackupStrategy.SYNC;
    }

    public long replicationTimeout() {
        return (Long)this.replicationTimeout.get();
    }

    public BackupConfiguration replicationTimeout(long timeout) {
        this.replicationTimeout.set((Object)timeout);
        return this;
    }

    public BackupFailurePolicy backupFailurePolicy() {
        return (BackupFailurePolicy)((Object)this.backupFailurePolicy.get());
    }

    public boolean isTwoPhaseCommit() {
        return (Boolean)this.useTwoPhaseCommit.get();
    }

    public boolean enabled() {
        return (Boolean)this.enabled.get();
    }

    public XSiteStateTransferConfiguration stateTransfer() {
        return this.xSiteStateTransferConfiguration;
    }

    public static enum BackupStrategy {
        SYNC,
        ASYNC;

    }
}

