/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ReadOperationNamesHandler
implements OperationStepHandler {
    private static final AttributeDefinition ACCESS_CONTROL = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("access-control", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-operation-names", ControllerResolver.getResolver("global")).setReadOnly().setParameters(ACCESS_CONTROL).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static OperationStepHandler INSTANCE = new ReadOperationNamesHandler();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ImmutableManagementResourceRegistration registry = context.getResourceRegistration();
        if (registry == null) {
            throw new OperationFailedException(ControllerLogger.ROOT_LOGGER.noSuchResourceType(context.getCurrentAddress()));
        }
        Map<String, OperationEntry> operations = registry.getOperationDescriptions(PathAddress.EMPTY_ADDRESS, true);
        boolean accessControl = ACCESS_CONTROL.resolveModelAttribute(context, operation).asBoolean();
        ModelNode result = new ModelNode();
        if (operations.size() > 0) {
            PathAddress address = context.getCurrentAddress();
            for (Map.Entry<String, OperationEntry> entry : operations.entrySet()) {
                if (!ReadOperationNamesHandler.isVisible(entry.getValue(), context)) continue;
                boolean add = true;
                if (accessControl) {
                    ModelNode operationToCheck = Util.createOperation(entry.getKey(), address);
                    operationToCheck.get("operation-headers").set(operation.get("operation-headers"));
                    AuthorizationResult authorizationResult = context.authorizeOperation(operationToCheck);
                    boolean bl = add = authorizationResult.getDecision() == AuthorizationResult.Decision.PERMIT;
                }
                if (add) {
                    result.add(entry.getKey());
                    continue;
                }
                context.getResponseHeaders().get(new String[]{"access-control", "filtered-operations"}).add(entry.getKey());
            }
        } else {
            result.setEmptyList();
        }
        context.getResult().set(result);
    }

    static boolean isVisible(OperationEntry operationEntry, OperationContext context) {
        Set<OperationEntry.Flag> flags = operationEntry.getFlags();
        return operationEntry.getType() == OperationEntry.EntryType.PUBLIC && !flags.contains((Object)OperationEntry.Flag.HIDDEN) && (context.getProcessType() != ProcessType.DOMAIN_SERVER || flags.contains((Object)OperationEntry.Flag.RUNTIME_ONLY) || flags.contains((Object)OperationEntry.Flag.READ_ONLY));
    }
}

