/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.impl.AbstractModelControllerClient;
import org.jboss.as.controller.client.impl.ProtocolConfigurationFactory;
import org.jboss.as.controller.client.logging.ControllerClientLogger;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.wildfly.common.ref.CleanerReference;
import org.wildfly.common.ref.Reaper;
import org.wildfly.common.ref.Reference;

public class RemotingModelControllerClient
extends AbstractModelControllerClient {
    private static final Reaper<RemotingModelControllerClient, ClientCloseable> REAPER = new Reaper<RemotingModelControllerClient, ClientCloseable>(){

        public void reap(Reference<RemotingModelControllerClient, ClientCloseable> reference) {
            ClientCloseable closeable = (ClientCloseable)reference.getAttachment();
            if (!closeable.closed) {
                ControllerClientLogger.LeakDescription t = ControllerClientLogger.ROOT_LOGGER.controllerClientNotClosed();
                t.setStackTrace(closeable.allocationStackTrace);
                ControllerClientLogger.ROOT_LOGGER.leakedControllerClient(t);
                StreamUtils.safeClose((Closeable)closeable);
            }
        }
    };
    private final ClientCloseable closeable;

    public static RemotingModelControllerClient create(ModelControllerClientConfiguration configuration) {
        RemotingModelControllerClient client = new RemotingModelControllerClient(configuration);
        new CleanerReference((Object)client, (Object)client.closeable, REAPER);
        return client;
    }

    @Deprecated
    public RemotingModelControllerClient(ModelControllerClientConfiguration configuration) {
        ManagementChannelHandler handler = new ManagementChannelHandler(new ManagementClientChannelStrategy(){

            public Channel getChannel() throws IOException {
                return RemotingModelControllerClient.this.getOrCreateChannel();
            }

            public synchronized void close() throws IOException {
            }
        }, configuration.getExecutor(), new ManagementRequestHandlerFactory[]{this});
        this.closeable = new ClientCloseable(handler, configuration, Thread.currentThread().getStackTrace());
    }

    @Override
    protected ManagementChannelAssociation getChannelAssociation() throws IOException {
        return this.closeable.channelAssociation;
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel getOrCreateChannel() throws IOException {
        ClientCloseable clientCloseable = this.closeable;
        synchronized (clientCloseable) {
            if (this.closeable.closed) {
                throw ControllerClientLogger.ROOT_LOGGER.objectIsClosed(ModelControllerClient.class.getSimpleName());
            }
            if (this.closeable.strategy == null) {
                try {
                    this.closeable.endpoint = Endpoint.builder().setEndpointName("management-client").build();
                    ProtocolConnectionConfiguration configuration = ProtocolConfigurationFactory.create(this.closeable.clientConfiguration, this.closeable.endpoint);
                    this.closeable.strategy = ManagementClientChannelStrategy.create((ProtocolConnectionConfiguration)configuration, (ManagementMessageHandler)this.closeable.channelAssociation, (CallbackHandler)this.closeable.clientConfiguration.getCallbackHandler(), this.closeable.clientConfiguration.getSaslOptions(), (SSLContext)this.closeable.clientConfiguration.getSSLContext(), (CloseHandler)new CloseHandler<Channel>(){

                        public void handleClose(Channel closed, IOException exception) {
                            RemotingModelControllerClient.this.closeable.channelAssociation.handleChannelClosed(closed, exception);
                        }
                    });
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.closeable.strategy.getChannel();
        }
    }

    private static final class ClientCloseable
    implements Closeable {
        private Endpoint endpoint;
        private ManagementClientChannelStrategy strategy;
        private boolean closed;
        private final ManagementChannelHandler channelAssociation;
        private final ModelControllerClientConfiguration clientConfiguration;
        private final StackTraceElement[] allocationStackTrace;

        private ClientCloseable(ManagementChannelHandler channelAssociation, ModelControllerClientConfiguration clientConfiguration, StackTraceElement[] allocationStackTrace) {
            this.channelAssociation = channelAssociation;
            this.clientConfiguration = clientConfiguration;
            this.allocationStackTrace = allocationStackTrace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ClientCloseable clientCloseable = this;
            synchronized (clientCloseable) {
                Endpoint endpoint;
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.channelAssociation.shutdown();
                if (this.strategy != null) {
                    StreamUtils.safeClose((Closeable)this.strategy);
                    this.strategy = null;
                }
                if ((endpoint = this.endpoint) != null) {
                    this.endpoint = null;
                    try {
                        endpoint.closeAsync();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                this.channelAssociation.shutdownNow();
                try {
                    this.channelAssociation.awaitCompletion(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    StreamUtils.safeClose((Closeable)this.clientConfiguration);
                }
                if (endpoint != null) {
                    try {
                        endpoint.awaitClosed();
                    }
                    catch (InterruptedException e) {
                        InterruptedIOException cause = new InterruptedIOException(e.getLocalizedMessage());
                        cause.initCause(e);
                        throw cause;
                    }
                }
            }
        }
    }
}

