/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.wildfly.common.Assert;
import org.wildfly.common.math.HashMath;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslClientFactory;

public final class ChannelBindingSaslClientFactory
extends AbstractDelegatingSaslClientFactory {
    private final String bindingType;
    private final byte[] bindingData;

    public ChannelBindingSaslClientFactory(SaslClientFactory delegate, String bindingType, byte[] bindingData) {
        super(delegate);
        Assert.checkNotNullParam("bindingType", bindingType);
        Assert.checkNotNullParam("bindingData", bindingData);
        this.bindingType = bindingType;
        this.bindingData = bindingData;
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        return this.delegate.createSaslClient(mechanisms, authorizationId, protocol, serverName, props, callbacks -> {
            ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
            Iterator<Callback> iterator = list.iterator();
            while (iterator.hasNext()) {
                Callback callback = iterator.next();
                if (!(callback instanceof ChannelBindingCallback)) continue;
                ((ChannelBindingCallback)callback).setBindingType(this.bindingType);
                ((ChannelBindingCallback)callback).setBindingData(this.bindingData);
                iterator.remove();
            }
            if (!list.isEmpty()) {
                cbh.handle(list.toArray(new Callback[list.size()]));
            }
        });
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ChannelBindingSaslClientFactory && this.equals((ChannelBindingSaslClientFactory)other);
    }

    @Override
    public boolean equals(AbstractDelegatingSaslClientFactory other) {
        return other instanceof ChannelBindingSaslClientFactory && this.equals((ChannelBindingSaslClientFactory)other);
    }

    public boolean equals(ChannelBindingSaslClientFactory other) {
        return super.equals(other) && this.bindingType.equals(other.bindingType) && Arrays.equals(this.bindingData, other.bindingData);
    }

    @Override
    protected int calculateHashCode() {
        return HashMath.multiHashOrdered(HashMath.multiHashOrdered(HashMath.multiHashOrdered(super.calculateHashCode(), this.getClass().hashCode()), this.bindingType.hashCode()), Arrays.hashCode(this.bindingData));
    }
}

