/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import org.jboss.as.connector.subsystems.jca.BeanValidationService;
import org.jboss.as.connector.subsystems.jca.JcaBeanValidationDefinition;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class BeanValidationAdd
extends AbstractBoottimeAddStepHandler {
    public static final BeanValidationAdd INSTANCE = new BeanValidationAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (JcaBeanValidationDefinition.BeanValidationParameters parameter : JcaBeanValidationDefinition.BeanValidationParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean enabled = JcaBeanValidationDefinition.BeanValidationParameters.BEAN_VALIDATION_ENABLED.getAttribute().resolveModelAttribute(context, model).asBoolean();
        ServiceName serviceName = ConnectorServices.BEAN_VALIDATION_CONFIG_SERVICE;
        ServiceName jcaConfigServiceName = ConnectorServices.CONNECTOR_CONFIG_SERVICE;
        ServiceTarget serviceTarget = context.getServiceTarget();
        BeanValidationService.BeanValidation config = new BeanValidationService.BeanValidation(enabled);
        BeanValidationService service = new BeanValidationService(config);
        ServiceController controller = serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(jcaConfigServiceName, JcaSubsystemConfiguration.class, service.getJcaConfigInjector()).install();
    }
}

