/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.config.smallrye;

import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.microprofile.config.smallrye.ConfigSourceDefinition;
import org.wildfly.extension.microprofile.config.smallrye.ConfigSourceProviderDefinition;
import org.wildfly.extension.microprofile.config.smallrye.IterableRegistry;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigSubsystemParser_1_0;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileConfigSubsystemParser_2_0;
import org.wildfly.extension.microprofile.config.smallrye.MicroProfileSubsystemDefinition;

public class MicroProfileConfigExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "microprofile-config-smallrye";
    protected static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"microprofile-config-smallrye");
    protected static final PathElement CONFIG_SOURCE_PATH = PathElement.pathElement((String)"config-source");
    protected static final PathElement CONFIG_SOURCE_PROVIDER_PATH = PathElement.pathElement((String)"config-source-provider");
    private static final String RESOURCE_NAME = MicroProfileConfigExtension.class.getPackage().getName() + ".LocalDescriptions";
    protected static final ModelVersion VERSION_1_0_0 = ModelVersion.create((int)1, (int)0, (int)0);
    protected static final ModelVersion VERSION_1_1_0 = ModelVersion.create((int)1, (int)1, (int)0);
    protected static final ModelVersion VERSION_2_0_0;
    private static final ModelVersion CURRENT_MODEL_VERSION;
    private static final MicroProfileConfigSubsystemParser_1_0 PARSER_1_0;
    private static final MicroProfileConfigSubsystemParser_2_0 PARSER_2_0;
    private static final XMLElementWriter<SubsystemMarshallingContext> CURRENT_WRITER;

    static ResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        return MicroProfileConfigExtension.getResourceDescriptionResolver(true, keyPrefix);
    }

    static ResourceDescriptionResolver getResourceDescriptionResolver(boolean useUnprefixedChildTypes, String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder();
        for (String kp : keyPrefix) {
            if (prefix.length() > 0) {
                prefix.append('.');
            }
            prefix.append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, MicroProfileConfigExtension.class.getClassLoader(), true, useUnprefixedChildTypes);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME, CURRENT_MODEL_VERSION);
        subsystem.registerXMLElementWriter(CURRENT_WRITER);
        IterableRegistry<ConfigSourceProvider> providers = new IterableRegistry<ConfigSourceProvider>();
        IterableRegistry<ConfigSource> sources = new IterableRegistry<ConfigSource>();
        ManagementResourceRegistration registration = subsystem.registerSubsystemModel((ResourceDefinition)new MicroProfileSubsystemDefinition(providers, sources));
        registration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
        registration.registerSubModel((ResourceDefinition)new ConfigSourceDefinition(providers, sources));
        registration.registerSubModel((ResourceDefinition)new ConfigSourceProviderDefinition(providers));
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:wildfly:microprofile-config-smallrye:1.0", (XMLElementReader)PARSER_1_0);
        context.setSubsystemXmlMapping(SUBSYSTEM_NAME, "urn:wildfly:microprofile-config-smallrye:2.0", (XMLElementReader)PARSER_2_0);
    }

    static {
        CURRENT_MODEL_VERSION = VERSION_2_0_0 = ModelVersion.create((int)2, (int)0, (int)0);
        PARSER_1_0 = new MicroProfileConfigSubsystemParser_1_0();
        PARSER_2_0 = new MicroProfileConfigSubsystemParser_2_0();
        CURRENT_WRITER = PARSER_2_0;
    }
}

