/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Frag3Header;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.FixedSizeBitSet;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.MessageIterator;
import org.jgroups.util.Util;

@MBean(description="Fragments messages larger than fragmentation size into smaller packets")
public class FRAG3
extends Protocol {
    @Property(description="The max number of bytes in a message. Larger messages will be fragmented")
    protected int frag_size = 60000;
    protected final ConcurrentMap<Address, ConcurrentMap<Integer, FragEntry>> fragment_list = Util.createConcurrentMap(11);
    protected final AtomicInteger curr_id = new AtomicInteger(1);
    protected final List<Address> members = new ArrayList<Address>(11);
    protected Address local_addr;
    @ManagedAttribute(description="Number of sent fragments")
    protected LongAdder num_frags_sent = new LongAdder();
    @ManagedAttribute(description="Number of received fragments")
    protected LongAdder num_frags_received = new LongAdder();
    protected final AverageMinMax avg_size_down = new AverageMinMax();
    protected final AverageMinMax avg_size_up = new AverageMinMax();

    public int getFragSize() {
        return this.frag_size;
    }

    public void setFragSize(int s) {
        this.frag_size = s;
    }

    public long getNumberOfSentFragments() {
        return this.num_frags_sent.sum();
    }

    public long getNumberOfReceivedFragments() {
        return this.num_frags_received.sum();
    }

    public int fragSize() {
        return this.frag_size;
    }

    public FRAG3 fragSize(int size) {
        this.frag_size = size;
        return this;
    }

    @ManagedAttribute(description="min/avg/max size (in bytes) for messages sent down that needed to be fragmented")
    public String getAvgSizeDown() {
        return this.avg_size_down.toString();
    }

    @ManagedAttribute(description="min/avg/max size (in bytes) of messages re-assembled from fragments")
    public String getAvgSizeUp() {
        return this.avg_size_up.toString();
    }

    protected int getNextId() {
        return this.curr_id.getAndIncrement();
    }

    @Override
    public void init() throws Exception {
        int max_bundle_size;
        super.init();
        int old_frag_size = this.frag_size;
        if (this.frag_size <= 0) {
            throw new Exception("frag_size=" + old_frag_size + ", new frag_size=" + this.frag_size + ": new frag_size is invalid");
        }
        TP transport = this.getTransport();
        if (transport != null && this.frag_size >= (max_bundle_size = transport.getMaxBundleSize())) {
            throw new IllegalArgumentException("frag_size (" + this.frag_size + ") has to be < TP.max_bundle_size (" + max_bundle_size + ")");
        }
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_frags_sent.reset();
        this.num_frags_received.reset();
        this.avg_size_down.clear();
        this.avg_size_up.clear();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        int size = msg.getLength();
        if (size > this.frag_size) {
            this.fragment(msg);
            this.avg_size_down.add(size);
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        Frag3Header hdr = (Frag3Header)msg.getHeader(this.id);
        if (hdr != null) {
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                assembled_msg.setSrc(msg.getSrc());
                this.up_prot.up(assembled_msg);
                this.avg_size_up.add(assembled_msg.length());
            }
            return null;
        }
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        MessageIterator it = batch.iterator();
        while (it.hasNext()) {
            Message msg = (Message)it.next();
            Frag3Header hdr = (Frag3Header)msg.getHeader(this.id);
            if (hdr == null) continue;
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                assembled_msg.setSrc(batch.sender());
                it.replace(assembled_msg);
                this.avg_size_up.add(assembled_msg.getLength());
                continue;
            }
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleViewChange(View view) {
        List<Address> new_mbrs = view.getMembers();
        List<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
        }
    }

    @ManagedOperation(description="removes all fragments sent by mbr")
    public void clearFragmentsFor(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.fragment_list.remove(mbr);
        this.log.trace("%s: removed %s from fragmentation table", this.local_addr, mbr);
    }

    @ManagedOperation(description="Removes all entries from the fragmentation table. Dangerous: this might remove fragments that are still needed to assemble an entire message")
    public void clearAllFragments() {
        this.fragment_list.clear();
    }

    protected void fragment(Message msg) {
        try {
            byte[] buffer = msg.getRawBuffer();
            int original_length = msg.getLength();
            int num_frags = (int)Math.ceil((double)original_length / (double)this.frag_size);
            this.num_frags_sent.add(num_frags);
            if (this.log.isTraceEnabled()) {
                Address dest = msg.getDest();
                this.log.trace("%s: fragmenting message to %s (size=%d) into %d fragment(s) [frag_size=%d]", this.local_addr, dest != null ? dest : "<all>", original_length, num_frags, this.frag_size);
            }
            int frag_id = this.getNextId();
            int total_size = original_length + msg.getOffset();
            int offset = msg.getOffset();
            int tmp_size = 0;
            int i = 0;
            while (offset < total_size) {
                tmp_size = offset + this.frag_size <= total_size ? this.frag_size : total_size - offset;
                Frag3Header hdr = new Frag3Header(frag_id, i, num_frags, original_length, offset - msg.getOffset());
                Message frag_msg = msg.copy(false, i == 0).setBuffer(buffer, offset, tmp_size).putHeader(this.id, hdr);
                this.down_prot.down(frag_msg);
                offset += tmp_size;
                ++i;
            }
        }
        catch (Exception e) {
            this.log.error(String.format("%s: fragmentation failure", this.local_addr), e);
        }
    }

    protected Message unfragment(Message msg, Frag3Header hdr) {
        ConcurrentMap tmp;
        Address sender = msg.getSrc();
        Message assembled_msg = null;
        ConcurrentMap<Integer, FragEntry> frag_table = (ConcurrentMap<Integer, FragEntry>)this.fragment_list.get(sender);
        if (frag_table == null && (tmp = this.fragment_list.putIfAbsent(sender, frag_table = Util.createConcurrentMap(16, 0.075f, 16))) != null) {
            frag_table = tmp;
        }
        this.num_frags_received.increment();
        FragEntry entry = (FragEntry)frag_table.get(hdr.id);
        if (entry == null) {
            entry = new FragEntry(hdr.num_frags);
            FragEntry tmp2 = frag_table.putIfAbsent(hdr.id, entry);
            if (tmp2 != null) {
                entry = tmp2;
            }
        }
        if ((assembled_msg = entry.set(msg, hdr)) != null) {
            frag_table.remove(hdr.id);
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: unfragmented message from %s (size=%d) from %d fragments", this.local_addr, sender, assembled_msg.getLength(), entry.num_frags);
            }
        }
        return assembled_msg;
    }

    protected static class FragEntry {
        protected final Lock lock = new ReentrantLock();
        protected Message msg;
        protected byte[] buffer;
        protected final int num_frags;
        protected final FixedSizeBitSet received;

        protected FragEntry(int num_frags) {
            this.num_frags = num_frags;
            this.received = new FixedSizeBitSet(num_frags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message set(Message frag_msg, Frag3Header hdr) {
            this.lock.lock();
            try {
                if (this.buffer == null) {
                    this.buffer = new byte[hdr.original_length];
                }
                if (hdr.frag_id == 0) {
                    this.msg = frag_msg.copy(false);
                }
                if (this.received.set(hdr.frag_id)) {
                    int frag_length = frag_msg.getLength();
                    int offset = hdr.offset;
                    System.arraycopy(frag_msg.getRawBuffer(), frag_msg.getOffset(), this.buffer, offset, frag_length);
                    if (this.isComplete()) {
                        Message message = this.assembleMessage();
                        return message;
                    }
                }
                Message message = null;
                return message;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected boolean isComplete() {
            return this.received.cardinality() == this.num_frags;
        }

        protected Message assembleMessage() {
            return this.msg.setBuffer(this.buffer);
        }

        public String toString() {
            return String.format("[tot_frags=%d, number_of_frags_recvd=%d]", this.num_frags, this.received.cardinality());
        }
    }
}

