/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.bearer;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.callback.IdentityCredentialCallback;
import org.wildfly.security.credential.BearerTokenCredential;
import org.wildfly.security.evidence.BearerTokenEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.mechanism.AuthenticationMechanismException;
import org.wildfly.security.mechanism._private.ElytronMessages;
import org.wildfly.security.mechanism._private.MechanismUtil;

final class BearerTokenAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    private final CallbackHandler callbackHandler;

    BearerTokenAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public String getMechanismName() {
        return "BEARER_TOKEN";
    }

    @Override
    public void evaluateRequest(HttpServerRequest request) throws HttpAuthenticationException {
        List<String> authorizationValues = request.getRequestHeaderValues("Authorization");
        if (authorizationValues != null) {
            for (String current : authorizationValues) {
                Matcher matcher = HttpConstants.BEARER_TOKEN_PATTERN.matcher(current);
                if (!matcher.matches()) continue;
                BearerTokenEvidence tokenEvidence = new BearerTokenEvidence(matcher.group(1));
                EvidenceVerifyCallback verifyCallback = new EvidenceVerifyCallback(tokenEvidence);
                this.handleCallback(verifyCallback);
                if (verifyCallback.isVerified()) {
                    AuthorizeCallback authorizeCallback = new AuthorizeCallback(null, null);
                    this.handleCallback(authorizeCallback);
                    if (authorizeCallback.isAuthorized()) {
                        ElytronMessages.httpBearer.debugf("Token authentication successful.", new Object[0]);
                        this.handleCallback(new IdentityCredentialCallback(new BearerTokenCredential(tokenEvidence.getToken()), true));
                        this.handleCallback(AuthenticationCompleteCallback.SUCCEEDED);
                        request.authenticationComplete();
                    } else {
                        ElytronMessages.httpBearer.debugf("Token authorization failed.", new Object[0]);
                        request.authenticationFailed("Authorization failed.", response -> response.setStatusCode(403));
                    }
                } else {
                    ElytronMessages.httpBearer.debugf("Token authentication failed.", new Object[0]);
                    request.authenticationFailed(ElytronMessages.httpBearer.authenticationFailed(), this::unauthorizedResponse);
                }
                return;
            }
        }
        request.noAuthenticationInProgress(this::unauthorizedResponse);
    }

    private void handleCallback(Callback callback) throws HttpAuthenticationException {
        try {
            MechanismUtil.handleCallbacks(ElytronMessages.httpBearer, this.callbackHandler, callback);
        }
        catch (AuthenticationMechanismException e) {
            throw e.toHttpAuthenticationException();
        }
        catch (UnsupportedCallbackException ignored) {
            ElytronMessages.httpBearer.tracef("Unsupported callback [%s]", (Object)callback);
        }
    }

    private void unauthorizedResponse(HttpServerResponse response) throws HttpAuthenticationException {
        StringBuilder sb = new StringBuilder("Bearer");
        String realmName = this.getRealmName();
        if (realmName != null) {
            sb.append(" ").append("realm").append("=\"").append(realmName).append("\"");
        }
        response.addResponseHeader("WWW-Authenticate", sb.toString());
        response.setStatusCode(401);
    }

    private String getRealmName() throws HttpAuthenticationException {
        try {
            AvailableRealmsCallback availableRealmsCallback = new AvailableRealmsCallback();
            this.callbackHandler.handle(new Callback[]{availableRealmsCallback});
            String[] realmNames = availableRealmsCallback.getRealmNames();
            if (realmNames != null && realmNames.length > 0) {
                return realmNames[0];
            }
        }
        catch (UnsupportedCallbackException availableRealmsCallback) {
        }
        catch (IOException e) {
            throw ElytronMessages.httpBearer.mechCallbackHandlerFailedForUnknownReason(e).toHttpAuthenticationException();
        }
        return null;
    }
}

