/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ImmediateManagedReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;

public final class LookupInjectionSource
extends InjectionSource {
    private static final String SLASH = "/";
    private static final Set<String> URL_SCHEMES;
    private final String lookupName;
    private final boolean optional;

    public LookupInjectionSource(String lookupName) {
        this(lookupName, false);
    }

    public LookupInjectionSource(String lookupName, boolean optional) {
        if (lookupName == null) {
            throw EeLogger.ROOT_LOGGER.nullVar("lookupName");
        }
        this.lookupName = lookupName;
        this.optional = optional;
    }

    @Override
    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        String applicationName = resolutionContext.getApplicationName();
        String moduleName = resolutionContext.getModuleName();
        String componentName = resolutionContext.getComponentName();
        boolean compUsesModule = resolutionContext.isCompUsesModule();
        String scheme = org.jboss.as.naming.InitialContext.getURLScheme((String)this.lookupName);
        if (scheme == null) {
            String sanitizedLookupName = this.sanitizeLookupName(this.lookupName);
            if (componentName != null && !compUsesModule) {
                ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)("java:comp/env/" + sanitizedLookupName)).setupLookupInjection(serviceBuilder, injector, phaseContext.getDeploymentUnit(), this.optional);
            } else if (compUsesModule) {
                ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)("java:module/env/" + sanitizedLookupName)).setupLookupInjection(serviceBuilder, injector, phaseContext.getDeploymentUnit(), this.optional);
            } else {
                ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)("java:jboss/env/" + sanitizedLookupName)).setupLookupInjection(serviceBuilder, injector, phaseContext.getDeploymentUnit(), this.optional);
            }
        } else if (scheme.equals("java")) {
            if (compUsesModule && this.lookupName.startsWith("java:comp/")) {
                ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)("java:module/" + this.lookupName.substring(10))).setupLookupInjection(serviceBuilder, injector, phaseContext.getDeploymentUnit(), this.optional);
            } else {
                ContextNames.bindInfoFor((String)applicationName, (String)moduleName, (String)componentName, (String)this.lookupName).setupLookupInjection(serviceBuilder, injector, phaseContext.getDeploymentUnit(), this.optional);
            }
        } else {
            Object managedReferenceFactory = URL_SCHEMES.contains(scheme) ? new ManagedReferenceFactory(){

                public ManagedReference getReference() {
                    try {
                        return new ImmediateManagedReference((Object)new URL(LookupInjectionSource.this.lookupName));
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
            } : new ManagedReferenceFactory(){

                public ManagedReference getReference() {
                    try {
                        return new ImmediateManagedReference(new InitialContext().lookup(LookupInjectionSource.this.lookupName));
                    }
                    catch (NamingException e) {
                        EeLogger.ROOT_LOGGER.tracef(e, "failed to lookup %s", LookupInjectionSource.this.lookupName);
                        return null;
                    }
                }
            };
            injector.inject(managedReferenceFactory);
        }
    }

    private String sanitizeLookupName(String lookupName) {
        int slashIndex = lookupName.indexOf(SLASH);
        if (slashIndex == 0) {
            EeLogger.ROOT_LOGGER.invalidNamePrefix(lookupName);
            return lookupName.substring(1);
        }
        return lookupName;
    }

    public boolean equals(Object configuration) {
        if (configuration instanceof LookupInjectionSource) {
            LookupInjectionSource lookup = (LookupInjectionSource)configuration;
            return this.lookupName.equals(lookup.lookupName);
        }
        return false;
    }

    public int hashCode() {
        return this.lookupName.hashCode();
    }

    public String toString() {
        return "lookup (" + this.lookupName + ")";
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add("http");
        set.add("https");
        set.add("ftp");
        set.add("file");
        set.add("jar");
        URL_SCHEMES = Collections.unmodifiableSet(set);
    }
}

